/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei;

import cy.jdkdigital.productivemetalworks.common.datamap.EntityMeltingMap;
import cy.jdkdigital.productivemetalworks.integration.jei.BlockCastingRecipeCategory;
import cy.jdkdigital.productivemetalworks.integration.jei.EntityMeltingRecipeCategory;
import cy.jdkdigital.productivemetalworks.integration.jei.FluidAlloyingRecipeCategory;
import cy.jdkdigital.productivemetalworks.integration.jei.ItemCastingRecipeCategory;
import cy.jdkdigital.productivemetalworks.integration.jei.ItemMeltingRecipeCategory;
import cy.jdkdigital.productivemetalworks.recipe.BlockCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.EntityMeltingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"productivemetalworks");
    public static final RecipeType<RecipeHolder<ItemMeltingRecipe>> ITEM_MELTING = RecipeType.createRecipeHolderType((ResourceLocation)MetalworksRegistrator.ITEM_MELTING_TYPE.getId());
    public static final RecipeType<RecipeHolder<EntityMeltingRecipe>> ENTITY_MELTING = RecipeType.createRecipeHolderType((ResourceLocation)MetalworksRegistrator.ENTITY_MELTING_TYPE.getId());
    public static final RecipeType<RecipeHolder<ItemCastingRecipe>> ITEM_CASTING = RecipeType.createRecipeHolderType((ResourceLocation)MetalworksRegistrator.ITEM_CASTING_TYPE.getId());
    public static final RecipeType<RecipeHolder<BlockCastingRecipe>> BLOCK_CASTING = RecipeType.createRecipeHolderType((ResourceLocation)MetalworksRegistrator.BLOCK_CASTING_TYPE.getId());
    public static final RecipeType<RecipeHolder<FluidAlloyingRecipe>> FLUID_ALLOYING = RecipeType.createRecipeHolderType((ResourceLocation)MetalworksRegistrator.FLUID_ALLOYING_TYPE.getId());
    public static final IIngredientType<Entity> ENTITY_INGREDIENT = () -> Entity.class;

    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemMeltingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemCastingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockCastingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidAlloyingRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        MetalworksRegistrator.FOUNDRY_CONTROLLERS.forEach((dyeColor, controller) -> {
            registration.addRecipeCatalyst((ItemLike)controller.get(), new RecipeType[]{ITEM_MELTING});
            registration.addRecipeCatalyst((ItemLike)controller.get(), new RecipeType[]{FLUID_ALLOYING});
            registration.addRecipeCatalyst((ItemLike)controller.get(), new RecipeType[]{ENTITY_MELTING});
        });
        registration.addRecipeCatalyst((ItemLike)MetalworksRegistrator.CASTING_TABLE.get(), new RecipeType[]{ITEM_CASTING});
        registration.addRecipeCatalyst((ItemLike)MetalworksRegistrator.CASTING_BASIN.get(), new RecipeType[]{BLOCK_CASTING});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(ITEM_MELTING, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MetalworksRegistrator.ITEM_MELTING_TYPE.get()));
        registration.addRecipes(ITEM_CASTING, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MetalworksRegistrator.ITEM_CASTING_TYPE.get()));
        registration.addRecipes(BLOCK_CASTING, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MetalworksRegistrator.BLOCK_CASTING_TYPE.get()));
        registration.addRecipes(FLUID_ALLOYING, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MetalworksRegistrator.FLUID_ALLOYING_TYPE.get()));
        BuiltInRegistries.ENTITY_TYPE.holders().forEach(entityType -> {
            EntityMeltingMap data = (EntityMeltingMap)entityType.getData(MetalworksRegistrator.ENTITY_MELTING_MAP);
            if (data != null) {
                ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)entityType.value()));
                registration.addRecipes(ENTITY_MELTING, List.of(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("/melting/entity/" + id.getPath())), (Recipe)new EntityMeltingRecipe(id, List.of(data.fluid())))));
            }
        });
        ArrayList WAXING_RECIPES = new ArrayList();
        BuiltInRegistries.BLOCK.holders().forEach(blockReference -> {
            Waxable waxData = (Waxable)blockReference.getData(NeoForgeDataMaps.WAXABLES);
            if (waxData != null) {
                WAXING_RECIPES.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)blockReference.key().location().getPath()), (Recipe)new BlockCastingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReference.value()}), SizedFluidIngredient.of((Fluid)((Fluid)MetalworksRegistrator.MOLTEN_WAX.get()), (int)50), waxData.waxed().asItem().getDefaultInstance(), true)));
            }
        });
        registration.addRecipes(BLOCK_CASTING, WAXING_RECIPES);
        ArrayList BUCKET_RECIPES = new ArrayList();
        BuiltInRegistries.FLUID.entrySet().forEach(fluidHolder -> {
            Fluid fluid = (Fluid)fluidHolder.getValue();
            if (fluid.defaultFluidState().isSource() && fluid.getBucket() != Items.AIR) {
                BUCKET_RECIPES.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)((ResourceKey)fluidHolder.getKey()).location().getPath()), (Recipe)new BlockCastingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUCKET}), SizedFluidIngredient.of((Fluid)fluid, (int)1000), fluid.getBucket().getDefaultInstance(), true)));
            }
        });
        registration.addRecipes(ITEM_CASTING, BUCKET_RECIPES);
    }
}

