/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.productivemetalworks.common.block.entity.CastingBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.RenderHelper;
import cy.jdkdigital.productivemetalworks.util.TintedItemRenderTypeBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;

public class CastingBlockEntityRenderer
implements BlockEntityRenderer<CastingBlockEntity> {
    public CastingBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CastingBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (blockEntity.getLevel() != null) {
            ItemStack output;
            ItemStack cast;
            boolean isTable = blockEntity.getBlockState().is((Block)MetalworksRegistrator.CASTING_TABLE.get());
            float recipeProgress = blockEntity.coolingTime > 0 ? (float)blockEntity.coolingTime / (float)blockEntity.maxAmount : 1.0f;
            FluidStack fluidStack = blockEntity.getFluidHandler().getFluid();
            if (!fluidStack.isEmpty()) {
                poseStack.pushPose();
                VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
                float fillProgress = (float)fluidStack.getAmount() / (float)blockEntity.maxAmount;
                float fluidY = (isTable ? 0.9375f : RenderHelper.pixelFraction) + fillProgress * (isTable ? 0.7f : 14.01f) * RenderHelper.pixelFraction;
                int[] range = IntStream.range(0, 1).toArray();
                RenderHelper.renderFullFluidLayer(poseStack, vertexBuffer, fluidY, fluidY, range, range, fluidStack, combinedLightIn, combinedOverlayIn, recipeProgress, 0.001f);
                poseStack.popPose();
            }
            if (!(cast = blockEntity.castInv.getStackInSlot(0)).isEmpty()) {
                poseStack.pushPose();
                if (isTable) {
                    poseStack.translate(0.5f, 0.96f, 0.5f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                } else {
                    if (!(cast.getItem() instanceof BlockItem)) {
                        poseStack.translate(0.5f, 0.5f, 0.5f);
                        poseStack.mulPose(Axis.YP.rotationDegrees(30.0f));
                        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    }
                    poseStack.translate(RenderHelper.pixelFraction, RenderHelper.pixelFraction, RenderHelper.pixelFraction);
                }
                poseStack.scale(0.875f, 0.875f, 0.875f);
                Item fluidY = cast.getItem();
                if (fluidY instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)fluidY;
                    Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockItem.getBlock().defaultBlockState(), poseStack, bufferSource, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
                } else {
                    Minecraft.getInstance().getItemRenderer().renderStatic(cast, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, blockEntity.getLevel(), 0);
                }
                poseStack.popPose();
            }
            if (!(output = blockEntity.getItemHandler().getStackInSlot(0)).isEmpty()) {
                if (blockEntity.coolingTime > 0) {
                    bufferSource = new TintedItemRenderTypeBuffer(bufferSource, (int)(1020.0f * (1.0f - recipeProgress)), (int)(1020.0f * recipeProgress));
                }
                poseStack.pushPose();
                if (isTable) {
                    poseStack.scale(0.98f, 0.99f, 0.98f);
                    poseStack.translate(0.51f, 0.965f, 0.51f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                } else {
                    poseStack.translate(RenderHelper.pixelFraction, RenderHelper.pixelFraction, RenderHelper.pixelFraction);
                    poseStack.scale(0.875f, 0.875f, 0.875f);
                }
                Item item = output.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockItem.getBlock().defaultBlockState(), poseStack, bufferSource, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
                } else {
                    Minecraft.getInstance().getItemRenderer().renderStatic(output, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, blockEntity.getLevel(), 0);
                }
                poseStack.popPose();
            }
        }
    }
}

