/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.cache.MMItemStackConstantChemicalToObjectCachedRecipe;
import com.jerry.mekmm.api.recipes.cache.MMTwoInputCachedRecipe;
import com.jerry.mekmm.api.recipes.outputs.MMOutputHelper;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.registries.MMBlocks;
import com.jerry.mekmm.common.upgrade.PlantingUpgradeData;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPlantingStation
extends TileEntityProgressMachine<PlantingRecipe>
implements IRecipeLookupHandler.ConstantUsageRecipeLookupHandler,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<PlantingRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_GAS = 210L;
    public IChemicalTank chemicalTank;
    private final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsageMultiplier;
    private double chemicalPerTickMeanMultiplier = 1.0;
    private long baseTotalUsage;
    private long usedSoFar;
    private final IOutputHandler<PlantingRecipe.PlantingStationRecipeOutput> outputHandler;
    private final IInputHandler<ItemStack> itemInputHandler;
    private final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    private MachineEnergyContainer<TileEntityPlantingStation> energyContainer;
    InputInventorySlot inputSlot;
    OutputInventorySlot mainOutputSlot;
    OutputInventorySlot secondaryOutputSlot;
    ChemicalInventorySlot chemicalSlot;
    EnergyInventorySlot energySlot;

    public TileEntityPlantingStation(BlockPos pos, BlockState state) {
        super(MMBlocks.PLANTING_STATION, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.mainOutputSlot, (IInventorySlot)this.chemicalSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.inputSlot), List.of(this.mainOutputSlot, this.secondaryOutputSlot), (IInventorySlot)this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        if (this.allowExtractingChemical()) {
            this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank, RelativeSide.RIGHT).setCanEject(false);
        } else {
            this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank);
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM}).setCanTankEject(tank -> tank != this.chemicalTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.chemicalTank);
        this.outputHandler = MMOutputHelper.getOutputHandler((IInventorySlot)this.mainOutputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)this.secondaryOutputSlot, NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR);
        this.baseTotalUsage = this.baseTicksRequired;
        this.chemicalUsageMultiplier = this.useStatisticalMechanics() ? (usedSoFar, operatingTicks) -> StatUtils.inversePoisson((double)this.chemicalPerTickMeanMultiplier) : ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier.constantUse(() -> this.baseTotalUsage, () -> ((TileEntityPlantingStation)this).getTicksRequired());
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.createModern((long)210L, (BiPredicate)(this.allowExtractingChemical() ? ConstantPredicates.alwaysTrueBi() : ConstantPredicates.notExternal()), (gas, automationType) -> this.containsRecipeBA(this.inputSlot.getStack(), gas), arg_0 -> ((TileEntityPlantingStation)this).containsRecipeB(arg_0), (IContentsListener)recipeCacheListener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, this.chemicalTank.getStack()), arg_0 -> ((TileEntityPlantingStation)this).containsRecipeA(arg_0), (IContentsListener)recipeCacheListener, (int)56, (int)17);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.chemicalSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.chemicalTank, () -> ((TileEntityPlantingStation)this).getLevel(), (IContentsListener)listener, (int)56, (int)53);
        builder.addSlot((IInventorySlot)this.chemicalSlot);
        this.mainOutputSlot = OutputInventorySlot.at((IContentsListener)recipeCacheUnpauseListener, (int)116, (int)35);
        builder.addSlot((IInventorySlot)this.mainOutputSlot);
        this.secondaryOutputSlot = OutputInventorySlot.at((IContentsListener)recipeCacheUnpauseListener, (int)132, (int)35);
        builder.addSlot((IInventorySlot)this.secondaryOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPlantingStation)this).getLevel(), (IContentsListener)listener, (int)31, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected boolean allowExtractingChemical() {
        return !this.useStatisticalMechanics();
    }

    protected boolean useStatisticalMechanics() {
        return MekanismConfig.usage.randomizedConsumption.get();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.chemicalSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, PlantingRecipe, InputRecipeCache.ItemChemical<PlantingRecipe>> getRecipeType() {
        return MoreMachineRecipeType.PLANTING_STATION;
    }

    @Nullable
    public IRecipeViewerRecipeType<PlantingRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.PLANTING_STATION;
    }

    @Nullable
    public PlantingRecipe getRecipe(int cacheIndex) {
        return (PlantingRecipe)this.findFirstRecipe((IInputHandler)this.itemInputHandler, (IInputHandler)this.chemicalInputHandler);
    }

    @NotNull
    public CachedRecipe<PlantingRecipe> createNewCachedRecipe(@NotNull PlantingRecipe recipe, int cacheIndex) {
        MMTwoInputCachedRecipe<Object, Object, PlantingRecipe.PlantingStationRecipeOutput, PlantingRecipe> cachedRecipe = recipe.perTickUsage() ? MMItemStackConstantChemicalToObjectCachedRecipe.planting(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.chemicalInputHandler, this.chemicalUsageMultiplier, used -> {
            this.usedSoFar = used;
        }, this.outputHandler) : MMTwoInputCachedRecipe.planting(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.chemicalInputHandler, this.outputHandler);
        return cachedRecipe.setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityPlantingStation)this).canFunction()).setActive(arg_0 -> ((TileEntityPlantingStation)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityPlantingStation)this).getTicksRequired()).setOnFinish(() -> ((TileEntityPlantingStation)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(() -> ((TileEntityPlantingStation)this).getOperationsPerTick());
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.CHEMICAL && this.supportsUpgrade(Upgrade.CHEMICAL)) {
            if (this.useStatisticalMechanics()) {
                this.chemicalPerTickMeanMultiplier = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
            } else {
                this.baseTotalUsage = MekanismUtils.getBaseUsage((IUpgradeTile)this, (int)this.baseTicksRequired);
            }
        }
    }

    @NotNull
    public PlantingUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new PlantingUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.getOperatingTicks(), this.usedSoFar, this.chemicalTank, this.energySlot, this.chemicalSlot, this.inputSlot, this.mainOutputSlot, this.secondaryOutputSlot, (List<ITileComponent>)this.getComponents());
    }

    public MachineEnergyContainer<TileEntityPlantingStation> getEnergyContainer() {
        return this.energyContainer;
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.usedSoFar = nbt.getLong("used_so_far");
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLong("used_so_far", this.usedSoFar);
    }

    public boolean isConfigurationDataCompatible(Block blockType) {
        return super.isConfigurationDataCompatible(blockType) || MekanismUtils.isSameTypeFactory((Holder)this.getBlockHolder(), (Block)blockType);
    }
}

