/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekmm.common.block.prefab.MMBlockFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MMFactoryType;
import com.jerry.mekmm.common.item.block.machine.MMItemBlockFactory;
import com.jerry.mekmm.common.registries.MMBlocks;
import com.jerry.mekmm.common.tile.TileEntityDoll;
import com.jerry.mekmm.common.tile.factory.MMTileEntityFactory;
import com.jerry.mekmm.common.tile.factory.MMTileEntityItemStackToItemStackFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityPlantingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityRecyclingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityReplicatingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityStampingFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityAmbientGasCollector;
import com.jerry.mekmm.common.tile.machine.TileEntityChemicalReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityFluidReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityLathe;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.tile.machine.TileEntityRecycler;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityRollingMill;
import com.jerry.mekmm.common.tile.machine.TileEntityStamper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MMTileEntityTypes {
    public static final TileEntityTypeDeferredRegister MM_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekmm");
    private static final Table<FactoryTier, MMFactoryType, TileEntityTypeRegistryObject<? extends MMTileEntityFactory<?>>> MM_FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<TileEntityRecycler> RECYCLER;
    public static final TileEntityTypeRegistryObject<TileEntityPlantingStation> PLANTING_STATION;
    public static final TileEntityTypeRegistryObject<TileEntityStamper> CNC_STAMPER;
    public static final TileEntityTypeRegistryObject<TileEntityLathe> CNC_LATHE;
    public static final TileEntityTypeRegistryObject<TileEntityRollingMill> CNC_ROLLING_MILL;
    public static final TileEntityTypeRegistryObject<TileEntityReplicator> REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityFluidReplicator> FLUID_REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalReplicator> CHEMICAL_REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityAmbientGasCollector> AMBIENT_GAS_COLLECTOR;
    public static final TileEntityTypeRegistryObject<TileEntityDoll> AUTHOR_DOLL;

    private MMTileEntityTypes() {
    }

    private static void registerFactory(FactoryTier tier, MMFactoryType type, MMBlockEntityFactory<? extends MMTileEntityFactory<?>> factoryConstructor) {
        BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, MMItemBlockFactory> block = MMBlocks.getMMFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = MM_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (MMTileEntityFactory)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        MM_FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    public static TileEntityTypeRegistryObject<? extends MMTileEntityFactory<?>> getMMFactoryTile(FactoryTier tier, MMFactoryType type) {
        return (TileEntityTypeRegistryObject)MM_FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends MMTileEntityFactory<?>>[] getFactoryTiles() {
        return MM_FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.RECYCLING, TileEntityRecyclingFactory::new);
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.PLANTING_STATION, TileEntityPlantingFactory::new);
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.CNC_STAMPING, TileEntityStampingFactory::new);
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.CNC_LATHING, MMTileEntityItemStackToItemStackFactory::new);
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.CNC_ROLLING_MILL, MMTileEntityItemStackToItemStackFactory::new);
            MMTileEntityTypes.registerFactory(tier, MMFactoryType.REPLICATING, TileEntityReplicatingFactory::new);
        }
        RECYCLER = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.RECYCLER, TileEntityRecycler::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PLANTING_STATION = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.PLANTING_STATION, TileEntityPlantingStation::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_STAMPER = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.CNC_STAMPER, TileEntityStamper::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_LATHE = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.CNC_LATHE, TileEntityLathe::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_ROLLING_MILL = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.CNC_ROLLING_MILL, TileEntityRollingMill::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.REPLICATOR, TileEntityReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FLUID_REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.FLUID_REPLICATOR, TileEntityFluidReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.CHEMICAL_REPLICATOR, TileEntityChemicalReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        AMBIENT_GAS_COLLECTOR = MM_TILE_ENTITY_TYPES.mekBuilder(MMBlocks.AMBIENT_GAS_COLLECTOR, TileEntityAmbientGasCollector::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        AUTHOR_DOLL = MM_TILE_ENTITY_TYPES.builder(MMBlocks.AUTHOR_DOLL, TileEntityDoll::new).build();
    }

    @FunctionalInterface
    private static interface MMBlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

