/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class MMBasicChemicalChemicalToChemicalRecipe
extends ChemicalChemicalToChemicalRecipe
implements IBasicChemicalOutput {
    protected final ChemicalStackIngredient leftInput;
    protected final ChemicalStackIngredient rightInput;
    protected final ChemicalStack output;

    public MMBasicChemicalChemicalToChemicalRecipe(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ChemicalStack output) {
        this.leftInput = Objects.requireNonNull(leftInput, "Left input cannot be null.");
        this.rightInput = Objects.requireNonNull(rightInput, "Right input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public boolean test(ChemicalStack input1, ChemicalStack input2) {
        return this.leftInput.test(input1) && this.rightInput.test(input2) || this.rightInput.test(input1) && this.leftInput.test(input2);
    }

    @Contract(value="_, _ -> new", pure=true)
    public ChemicalStack getOutput(ChemicalStack input1, ChemicalStack input2) {
        return this.output.copy();
    }

    public ChemicalStackIngredient getLeftInput() {
        return this.leftInput;
    }

    public ChemicalStackIngredient getRightInput() {
        return this.rightInput;
    }

    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public ChemicalStack getOutputRaw() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MMBasicChemicalChemicalToChemicalRecipe other = (MMBasicChemicalChemicalToChemicalRecipe)((Object)o);
        return this.leftInput.equals((Object)other.leftInput) && this.rightInput.equals((Object)other.rightInput) && this.output.equals((Object)other.output);
    }

    public int hashCode() {
        return Objects.hash(this.leftInput, this.rightInput, this.output);
    }
}

