/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class BaseRecipeProvider
extends RecipeProvider {
    private final CompletableFuture<HolderLookup.Provider> registriesFuture;
    private final ExistingFileHelper existingFileHelper;

    protected BaseRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, ExistingFileHelper existingFileHelper) {
        super(output, registriesFuture);
        this.registriesFuture = registriesFuture;
        this.existingFileHelper = existingFileHelper;
    }

    protected final void buildRecipes(RecipeOutput output) {
        HolderLookup.Provider registries = this.registriesFuture.resultNow();
        WrapperRecipeOutput trackingConsumer = new WrapperRecipeOutput(output, this.existingFileHelper);
        this.addRecipes(trackingConsumer, registries);
        for (ISubRecipeProvider subRecipeProvider : this.getSubRecipeProviders()) {
            subRecipeProvider.addRecipes(trackingConsumer, registries);
        }
    }

    protected abstract void addRecipes(RecipeOutput var1, HolderLookup.Provider var2);

    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return Collections.emptyList();
    }

    public static Ingredient createIngredient(TagKey<Item> itemTag, ItemLike ... items) {
        return BaseRecipeProvider.createIngredient(Collections.singleton(itemTag), items);
    }

    public static Ingredient createIngredient(Collection<TagKey<Item>> itemTags, ItemLike ... items) {
        return Ingredient.fromValues(Stream.concat(itemTags.stream().map(Ingredient.TagValue::new), Arrays.stream(items).map(item -> new Ingredient.ItemValue(new ItemStack(item)))));
    }

    @SafeVarargs
    public static Ingredient createIngredient(TagKey<Item> ... tags) {
        return Ingredient.fromValues(Arrays.stream(tags).map(Ingredient.TagValue::new));
    }

    public static Ingredient difference(TagKey<Item> base, ItemLike subtracted) {
        return DifferenceIngredient.of((Ingredient)Ingredient.of(base), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{subtracted}));
    }

    public static TagKey<Item> osmiumIngot() {
        return Objects.requireNonNull((TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.OSMIUM));
    }

    public static TagKey<Item> leadIngot() {
        return Objects.requireNonNull((TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.LEAD));
    }

    public static TagKey<Item> tinIngot() {
        return Objects.requireNonNull((TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.TIN));
    }

    private record WrapperRecipeOutput(RecipeOutput parent, ExistingFileHelper existingFileHelper) implements RecipeOutput
    {
        public void accept(ResourceLocation recipeId, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... conditions) {
            this.parent.accept(recipeId, recipe, advancementHolder, conditions);
            this.existingFileHelper.trackGenerated(recipeId, PackType.SERVER_DATA, ".json", "recipes");
        }

        public Advancement.Builder advancement() {
            return this.parent.advancement();
        }
    }
}

