/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_polymorphia.polymorph;

import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.illusivesoulworks.polymorph.api.client.widgets.PlayerRecipesWidget;
import com.mojang.datafixers.util.Pair;
import dev.qther.ars_polymorphia.ArsPolymorphia;
import dev.qther.ars_polymorphia.packets.serverbound.PacketResetCraftingResult;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;

public class CraftingTerminalWidget
extends PlayerRecipesWidget {
    public static final WidgetSprites OUTPUT = new WidgetSprites(ArsPolymorphia.prefix("output_button"), ArsPolymorphia.prefix("output_button_highlighted"));
    public static final WidgetSprites CURRENT_OUTPUT = new WidgetSprites(ArsPolymorphia.prefix("current_output"), ArsPolymorphia.prefix("current_output_highlighted"));
    public static final WidgetSprites SELECTOR = new WidgetSprites(ArsPolymorphia.prefix("selector_button"), ArsPolymorphia.prefix("selector_button_highlighted"));
    protected final AbstractContainerMenu menu;

    public CraftingTerminalWidget(AbstractStorageTerminalScreen screen, Slot outputSlot) {
        super((AbstractContainerScreen)screen, outputSlot);
        this.menu = screen.getMenu();
    }

    public void selectRecipe(ResourceLocation id) {
        super.selectRecipe(id);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Optional recipe = player.level().getRecipeManager().byKey(id);
        if (recipe.isEmpty()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)PacketResetCraftingResult.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public WidgetSprites getSelectorSprites() {
        return SELECTOR;
    }

    public Pair<WidgetSprites, WidgetSprites> getOutputSprites() {
        return Pair.of((Object)OUTPUT, (Object)CURRENT_OUTPUT);
    }

    public int getYPos() {
        return super.getYPos() - 2;
    }
}

