/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.RollerWeightSelectorButtonComponent;
import com.buuz135.sushigocrafting.client.gui.provider.RollerAssetProvider;
import com.buuz135.sushigocrafting.component.FoodTypeButtonComponent;
import com.buuz135.sushigocrafting.component.RollerCraftButtonComponent;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class RollerTile
extends ActiveTile<RollerTile> {
    @Save
    private final InventoryComponent<RollerTile> slots;
    @Save
    private final WeightTracker weightTracker;
    @Save
    private final InventoryComponent<RollerTile> spices;
    @Save
    private String selected;
    @Save
    private int craftProgress;

    public RollerTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.ROLLER.get(), (BlockEntityType)SushiContent.TileEntities.ROLLER.get(), pos, state);
        int i = 0;
        int max = 0;
        this.craftProgress = 0;
        for (IFoodType foodType : FoodAPI.get().getFoodTypes()) {
            if (this.selected == null) {
                this.selected = foodType.getName();
            }
            max = Math.max(max, foodType.getFoodIngredients().size());
            ++i;
        }
        this.weightTracker = new WeightTracker(this, max);
        this.slots = new InventoryComponent("slots", 0, 0, max).setSlotPosition(FoodAPI.get().getTypeFromName(this.selected).get().getSlotPosition()).setInputFilter((stack, integer) -> {
            List<IFoodIngredient[]> ingredients = FoodAPI.get().getTypeFromName(this.selected).get().getFoodIngredients();
            if (integer >= ingredients.size()) {
                return false;
            }
            for (IFoodIngredient ingredient : ingredients.get((int)integer)) {
                if (ingredient.isEmpty() || !ingredient.getItem().equals(stack.getItem())) continue;
                return true;
            }
            return false;
        });
        this.addInventory(this.slots);
        this.spices = new InventoryComponent("spices", 130, 76, 2).setSlotLimit(1).setSlotToColorRender(0, DyeColor.YELLOW).setSlotToColorRender(1, DyeColor.YELLOW).setSlotToItemStackRender(0, new ItemStack((ItemLike)SushiContent.Items.SOY_SAUCE.get())).setSlotToItemStackRender(1, new ItemStack((ItemLike)SushiContent.Items.WASABI_PASTE.get())).setInputFilter((stack, integer) -> {
            if (integer == 0) {
                return stack.getItem().equals(SushiContent.Items.SOY_SAUCE.get());
            }
            if (integer == 1) {
                return stack.getItem().equals(SushiContent.Items.WASABI_PASTE.get());
            }
            return false;
        });
        this.addInventory(this.spices);
        this.addInventory(this.spices);
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                this.slots.setSlotToItemStackRender(slot, iFoodType.getSlotStackRender().apply(slot));
                this.slots.setSlotToColorRender(slot, 16762729);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        int i = 0;
        for (IFoodType foodType : FoodAPI.get().getFoodTypes()) {
            this.addButton(new FoodTypeButtonComponent(foodType, -20, i * 20 + 10, 18, 18){

                @Override
                public Supplier<String> getSelected() {
                    return () -> RollerTile.this.selected;
                }
            }.setComponent(this::getSlots));
            ++i;
        }
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            int i1 = 0;
            while (i1 < this.slots.getSlots()) {
                final int finalI = i1++;
                this.addGuiAddonFactory(() -> new RollerWeightSelectorButtonComponent(this.slots, finalI){

                    @Override
                    public int getWeight() {
                        return RollerTile.this.weightTracker.weights.get(finalI);
                    }

                    @Override
                    public String getType() {
                        return RollerTile.this.selected;
                    }
                });
            }
        });
        this.addButton(new RollerCraftButtonComponent(148, 20, 18, 18).setId(101));
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemInteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.result().shouldSwing()) {
            if (!player.hasData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY)) {
                player.setData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY, (Object)new SushiWeightDiscoveryCapability());
            }
            SushiWeightDiscoveryCapability data = (SushiWeightDiscoveryCapability)player.getData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY);
            if (player instanceof ServerPlayer) {
                data.requestUpdate((ServerPlayer)player, new ItemStack((ItemLike)Items.STONE), null);
            }
            this.openGui(player);
            return ItemInteractionResult.SUCCESS;
        }
        return type;
    }

    public void onClick(Player player) {
        if (this.isServer()) {
            FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
                boolean allFull = true;
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    IFoodIngredient ingredient;
                    if (i1 >= iFoodType.getFoodIngredients().size() || (ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(i1).getItem())).isEmpty() || ingredient.getIngredientConsumer().canConsume(ingredient, this.slots.getStackInSlot(i1), this.weightTracker.weights.get(i1))) continue;
                    allFull = false;
                    break;
                }
                if (allFull) {
                    ++this.craftProgress;
                    if (this.craftProgress >= 4) {
                        Random random = new Random(((ServerLevel)this.level).getSeed() + (long)this.selected.hashCode());
                        this.craftProgress = 0;
                        ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>();
                        ArrayList<Integer> weightValues = new ArrayList<Integer>();
                        AtomicReference<ItemStack> discovery = new AtomicReference<ItemStack>(ItemStack.EMPTY);
                        for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                            if (slot >= iFoodType.getFoodIngredients().size()) continue;
                            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(slot).getItem());
                            foodIngredients.add(ingredient);
                        }
                        FoodItem item = FoodHelper.getFoodFromIngredients(this.selected, foodIngredients);
                        if (item != null) {
                            ItemStack stack = new ItemStack((ItemLike)item);
                            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                                if (slot >= iFoodType.getFoodIngredients().size()) continue;
                                IFoodIngredient ingredient = (IFoodIngredient)foodIngredients.get(slot);
                                ingredient.getIngredientConsumer().consume(ingredient, this.slots.getStackInSlot(slot), this.weightTracker.weights.get(slot));
                                int value = random.nextInt(5) - this.weightTracker.weights.get(slot);
                                weightValues.add(value);
                                if (value != 0 || ingredient.isEmpty()) continue;
                                int finalSlot = slot;
                                SushiWeightDiscoveryCapability iSushiWeightDiscovery = (SushiWeightDiscoveryCapability)player.getData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY);
                                if (iSushiWeightDiscovery.hasDiscovery(this.selected + "-" + finalSlot)) continue;
                                iSushiWeightDiscovery.setDiscovery(this.selected + "-" + finalSlot, this.weightTracker.weights.get(finalSlot));
                                discovery.set(stack.copy());
                            }
                            stack.set(SushiDataComponent.FOOD_WEIGHTS, weightValues);
                            CompoundTag spicesNBT = new CompoundTag();
                            for (int i = 0; i < this.spices.getSlots(); ++i) {
                                IFoodIngredient soy;
                                if (this.spices.getStackInSlot(i).isEmpty() || !(soy = FoodAPI.get().getIngredientFromItem(this.spices.getStackInSlot(i).getItem())).getIngredientConsumer().canConsume(soy, this.spices.getStackInSlot(i), 0)) continue;
                                soy.getIngredientConsumer().consume(soy, this.spices.getStackInSlot(i), 0);
                                spicesNBT.putBoolean(soy.getName(), true);
                            }
                            stack.set(SushiDataComponent.FOOD_SPICES, (Object)spicesNBT);
                            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)stack);
                        }
                        if (player instanceof ServerPlayer && !discovery.get().isEmpty()) {
                            ((SushiWeightDiscoveryCapability)player.getData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY)).requestUpdate((ServerPlayer)player, discovery.get(), null);
                        }
                        this.markForUpdate();
                    }
                }
            });
        }
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (compound.contains("Type")) {
            FoodAPI.get().getTypeFromName(compound.getString("Type")).ifPresent(iFoodType -> {
                int i;
                ItemStack slotStack;
                this.slots.setSlotPosition(iFoodType.getSlotPosition());
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    if (i1 < iFoodType.getFoodIngredients().size()) {
                        this.slots.setSlotLimit(i1, 64);
                        continue;
                    }
                    slotStack = this.slots.getStackInSlot(i1).copy();
                    this.slots.setStackInSlot(i1, ItemStack.EMPTY);
                    this.slots.setSlotLimit(i1, 0);
                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)slotStack);
                }
                this.selected = compound.getString("Type");
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    this.slots.setSlotToItemStackRender(i, iFoodType.getSlotStackRender().apply(i));
                }
                this.syncObject(this.slots);
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    if (this.slots.isItemValid(i, this.slots.getStackInSlot(i))) continue;
                    slotStack = this.slots.getStackInSlot(i).copy();
                    this.slots.setStackInSlot(i, ItemStack.EMPTY);
                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)slotStack);
                }
                this.markForUpdate();
            });
        }
        if (id == 100) {
            int weight = compound.getInt("WeightSlot");
            int button = compound.getInt("Button");
            if (button == 0) {
                this.weightTracker.weights.set(weight, Math.min(4, this.weightTracker.weights.get(weight) + 1));
            }
            if (button == 1) {
                this.weightTracker.weights.set(weight, Math.max(0, this.weightTracker.weights.get(weight) - 1));
            }
            this.syncObject(this.weightTracker);
        }
        if (id == 101) {
            int amount = 1;
            if (compound.contains("Button")) {
                amount = compound.getInt("Button") == 1 ? 64 : 1;
            }
            for (int i = 0; i < amount; ++i) {
                this.craftProgress = 4;
                this.onClick(playerEntity);
            }
        }
    }

    public RollerTile getSelf() {
        return this;
    }

    public InventoryComponent<RollerTile> getSlots() {
        return this.slots;
    }

    public IAssetProvider getAssetProvider() {
        return RollerAssetProvider.INSTANCE;
    }

    public WeightTracker getWeightTracker() {
        return this.weightTracker;
    }

    public InventoryComponent<RollerTile> getSpices() {
        return this.spices;
    }

    public class WeightTracker
    implements INBTSerializable<CompoundTag> {
        private List<Integer> weights = new ArrayList<Integer>();

        public WeightTracker(RollerTile this$0, int amount) {
            for (int i = 0; i < amount; ++i) {
                this.weights.add(0);
            }
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putIntArray("Weights", this.weights);
            return compoundNBT;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.weights = new ArrayList<Integer>();
            for (int i : nbt.getIntArray("Weights")) {
                this.weights.add(i);
            }
        }

        public List<Integer> getWeights() {
            return this.weights;
        }
    }
}

