/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class FermentationBarrelTile
extends ActiveTile<FermentationBarrelTile> {
    @Save
    private final FluidTankComponent<FermentationBarrelTile> fluid;
    @Save
    private final InventoryComponent<FermentationBarrelTile> input;
    @Save
    private final InventoryComponent<FermentationBarrelTile> output;
    @Save
    private ProgressBarComponent<FermentationBarrelTile> bar = new ProgressBarComponent(93, 48, 100).setCanIncrease(FermentationBarrelTile::canStart).setCanReset(FermentationBarrelTile::canStart).setOnTickWork(() -> this.syncObject(this.bar)).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setOnFinishWork(() -> {
        this.onFinish();
        this.syncObject(this.bar);
        this.setChanged();
    });

    public FermentationBarrelTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.FERMENTATION_BARREL.get(), (BlockEntityType)SushiContent.TileEntities.FERMENTATION_BARREL.get(), pos, state);
        this.addProgressBar(this.bar);
        this.input = new InventoryComponent("input", 30, 48, 1).setSlotToColorRender(0, DyeColor.BLUE).setOutputFilter((i, s) -> false);
        this.addInventory(this.input);
        this.output = new InventoryComponent("output", 130, 48, 1).setSlotToColorRender(0, DyeColor.ORANGE).setInputFilter((i, s) -> false);
        this.addInventory(this.output);
        this.fluid = new FluidTankComponent("fluid", 2000, 59, 46).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL);
        this.addTank(this.fluid);
    }

    @Nonnull
    public FermentationBarrelTile getSelf() {
        return this;
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemInteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.result().shouldSwing()) {
            this.openGui(player);
            return ItemInteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean canStart() {
        return RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)SushiContent.RecipeTypes.FERMENTING_BARREL.get())).stream().anyMatch(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.is(this.fluid.getFluid().getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.canStack((FermentingBarrelRecipe)fermentingBarrelRecipe));
    }

    public boolean canStack(FermentingBarrelRecipe recipe) {
        Item item;
        ItemStack outputStack = this.output.getStackInSlot(0);
        if (outputStack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)outputStack, (ItemStack)recipe.getOutput()) || !((item = outputStack.getItem()) instanceof AmountItem)) {
            return false;
        }
        AmountItem outputAmount = (AmountItem)item;
        return outputAmount.getCurrentAmount(outputStack.copy()) < outputAmount.getMaxCombineAmount();
    }

    public void onFinish() {
        RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)SushiContent.RecipeTypes.FERMENTING_BARREL.get())).stream().filter(fermentingBarrelRecipe -> fermentingBarrelRecipe.input.test(this.input.getStackInSlot(0)) && (fermentingBarrelRecipe.fluid.isEmpty() || fermentingBarrelRecipe.fluid.is(this.fluid.getFluid().getFluid()) && this.fluid.getFluid().getAmount() >= fermentingBarrelRecipe.fluid.getAmount()) && this.canStack((FermentingBarrelRecipe)fermentingBarrelRecipe)).findFirst().ifPresent(fermentingBarrelRecipe -> {
            this.input.getStackInSlot(0).shrink(1);
            this.fluid.drainForced(fermentingBarrelRecipe.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            if (fermentingBarrelRecipe.output.getItem() instanceof AmountItem) {
                ItemStack outputStack = this.output.getStackInSlot(0);
                ItemStack recipeOutput = ((AmountItem)fermentingBarrelRecipe.output.getItem()).random(null, this.level);
                if (outputStack.isEmpty()) {
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)recipeOutput, (boolean)false);
                } else {
                    AmountItem.combineStacks(outputStack, recipeOutput);
                }
            } else {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)fermentingBarrelRecipe.output.copy(), (boolean)false);
            }
        });
    }

    public ProgressBarComponent<FermentationBarrelTile> getBar() {
        return this.bar;
    }
}

