/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.entity;

import com.buuz135.sushigocrafting.proxy.SushiContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShrimpEntity
extends AbstractSchoolingFish
implements ItemSteerable,
Saddleable {
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(ShrimpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(ShrimpEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemBasedSteering steering;

    public ShrimpEntity(EntityType<? extends AbstractSchoolingFish> type, Level worldIn) {
        super(type, worldIn);
        this.steering = new ItemBasedSteering(this.entityData, BOOST_TIME, SADDLED);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SADDLED, (Object)false);
        builder.define(BOOST_TIME, (Object)0);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)SushiContent.Items.SHRIMP_BUCKET.get());
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.COD_FLOP;
    }

    public boolean isSaddleable() {
        return this.isAlive();
    }

    public void equipSaddle(ItemStack itemStack, @Nullable SoundSource soundSource) {
        this.steering.setSaddle(true);
        if (soundSource != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.PIG_SADDLE, soundSource, 0.5f, 1.0f);
        }
    }

    public InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        if (this.isSaddled() && !this.isVehicle() && !playerIn.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                playerIn.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        InteractionResult actionresulttype = super.mobInteract(playerIn, hand);
        if (!actionresulttype.consumesAction()) {
            ItemStack itemstack = playerIn.getItemInHand(hand);
            return itemstack.getItem() == Items.SADDLE ? itemstack.interactLivingEntity(playerIn, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return actionresulttype;
    }

    @javax.annotation.Nullable
    public LivingEntity getControllingPassenger() {
        return this.getPassengers().isEmpty() ? null : (this.getPassengers().get(0) instanceof LivingEntity ? (LivingEntity)this.getPassengers().get(0) : null);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (BOOST_TIME.equals(key) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.steering.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.steering.readAdditionalSaveData(compound);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    public void travel(Vec3 travelVector) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle() && this.canBeControlledByRider() && entity instanceof Player && this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-entity.getRotationVector().x / 500.0f), 0.0));
        }
        super.travel(travelVector);
    }

    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(livingEntity);
        }
        int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.getDismountPoses()) {
            AABB axisalignedbb = livingEntity.getLocalBoundsForPose(pose);
            for (int[] aint1 : aint) {
                blockpos$mutable.set(blockpos.getX() + aint1[0], blockpos.getY(), blockpos.getZ() + aint1[1]);
                double d0 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutable);
                if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                Vec3 vector3d = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutable, (double)d0);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)livingEntity, (AABB)axisalignedbb.move(vector3d))) continue;
                livingEntity.setPose(pose);
                return vector3d;
            }
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    public boolean canBeControlledByRider() {
        LivingEntity entity = this.getControllingPassenger();
        if (!(entity instanceof Player)) {
            return false;
        }
        Player playerentity = (Player)entity;
        return playerentity.getMainHandItem().getItem() == SushiContent.Items.SEAWEED_ON_A_STICK.get() || playerentity.getOffhandItem().getItem() == SushiContent.Items.SEAWEED_ON_A_STICK.get();
    }

    public boolean isControlledByLocalInstance() {
        return super.isControlledByLocalInstance();
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity);
    }
}

