/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SushiModelProvider
extends BlockModelProvider {
    public SushiModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), modid, existingFileHelper);
    }

    protected void registerModels() {
        this.customCrop((CropBlock)SushiContent.Blocks.RICE_CROP.get(), "rice", 3);
        this.customCrop((CropBlock)SushiContent.Blocks.CUCUMBER_CROP.get(), "cucumber", new Integer[0]);
        this.customCrop((CropBlock)SushiContent.Blocks.SOY_CROP.get(), "soy", new Integer[0]);
        this.customCrop((CropBlock)SushiContent.Blocks.WASABI_CROP.get(), "wasabi", new Integer[0]);
        this.customCrop((CropBlock)SushiContent.Blocks.SESAME_CROP.get(), "sesame", new Integer[0]);
    }

    public void customCrop(CropBlock block, String name, Integer ... filterValues) {
        for (Integer allowedValue : CustomCropBlock.AGE.getPossibleValues()) {
            if (filterValues != null && Arrays.asList(filterValues).contains(allowedValue)) continue;
            ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_" + allowedValue)).parent((ModelFile)this.getUnchecked(this.mcLoc("block/crop")))).texture("crop", this.modLoc("block/" + name + "_stage_" + allowedValue));
        }
    }

    public ModelFile.UncheckedModelFile getUnchecked(ResourceLocation path) {
        ModelFile.UncheckedModelFile ret = new ModelFile.UncheckedModelFile(this.extendWithFolder(path));
        ret.assertExistence();
        return ret;
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.getPath().contains("/")) {
            return rl;
        }
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(this.folder + "/" + rl.getPath()));
    }
}

