/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.gui;

import com.buuz135.sushigocrafting.client.gui.provider.SushiAssetTypes;
import com.buuz135.sushigocrafting.component.RollerCraftButtonComponent;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RollerCraftButtonAddon
extends BasicButtonAddon {
    public RollerCraftButtonAddon(RollerCraftButtonComponent buttonComponent) {
        super((ButtonComponent)buttonComponent);
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundLayer(guiGraphics, screen, provider, guiX, guiY, mouseX, mouseY, partialTicks);
        IAsset asset = provider.getAsset(SushiAssetTypes.ROLLER_TYPE_BG);
        if (asset != null) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX() - 1), (int)(guiY + this.getPosY() - 1));
        }
        if ((asset = provider.getAsset(SushiAssetTypes.ROLLER_TYPE_BG_OVER)) != null) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX() - 1), (int)(guiY + this.getPosY() - 1));
        }
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, new ItemStack((ItemLike)SushiContent.Items.ROLLER.get()), guiX + this.getPosX(), guiY + this.getPosY() - 4);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AbstractContainerMenu abstractContainerMenu;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && (abstractContainerMenu = ((AbstractContainerScreen)screen).getMenu()) instanceof ILocatable) {
            ILocatable locatable = (ILocatable)abstractContainerMenu;
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.2f, 1.0f, Minecraft.getInstance().level.getRandom(), Minecraft.getInstance().player.blockPosition()));
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("Button", button);
            Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), this.getButton().getId(), nbt));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public List<Component> getTooltipLines() {
        return Arrays.asList(Component.translatable((String)"text.sushigocrafting.roll"), Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "*" + String.valueOf(Component.translatable((String)"text.sushigocrafting.make_one")) + "*")), Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "*" + String.valueOf(Component.translatable((String)"text.sushigocrafting.make_64")) + "*")));
    }

    public RollerCraftButtonComponent getButton() {
        return (RollerCraftButtonComponent)super.getButton();
    }
}

