/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.entity;

import com.buuz135.sushigocrafting.client.entity.model.ShrimpModel;
import com.buuz135.sushigocrafting.entity.ShrimpEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ShrimpRenderer
extends MobRenderer<ShrimpEntity, ShrimpModel> {
    private static final ResourceLocation SHRIMP_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"textures/entity/shrimp.png");

    public ShrimpRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ShrimpModel(renderManagerIn.bakeLayer(new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"shrimp"), "main"))), 0.3f);
    }

    public ResourceLocation getTextureLocation(ShrimpEntity entity) {
        return SHRIMP_LOCATION;
    }

    protected void setupRotations(ShrimpEntity entity, PoseStack matrixStackIn, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)entity, matrixStackIn, bob, yBodyRot, partialTick, scale);
        float f = Mth.sin((float)(0.3f * bob));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(f));
        if (!entity.isInWater()) {
            matrixStackIn.translate(0.1f, 0.1f, -0.1f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

