/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.particles;

import com.almostreliable.ponderjs.mixin.ParticleAccessor;
import com.almostreliable.ponderjs.mixin.PonderWorldAccessor;
import com.almostreliable.ponderjs.particles.ParticleDataBuilder;
import com.almostreliable.ponderjs.particles.ParticleTransformation;
import com.almostreliable.ponderjs.util.PonderErrorHelper;
import dev.latvian.mods.kubejs.color.KubeColor;
import java.util.ArrayList;
import java.util.List;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.createmod.ponder.foundation.instruction.TickingInstruction;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ParticleInstructions {
    private final SceneBuilder scene;

    public ParticleInstructions(SceneBuilder scene) {
        this.scene = scene;
    }

    public ParticleDataBuilder<?, ?> simple(int ticks, ParticleType<?> type, Vec3 pos) {
        if (type instanceof SimpleParticleType) {
            SimpleParticleType simple = (SimpleParticleType)type;
            return this.create(ticks, pos, new ParticleDataBuilder.Static((ParticleOptions)simple));
        }
        throw new IllegalArgumentException("Particle type " + String.valueOf(type == null ? "INVALID" : BuiltInRegistries.PARTICLE_TYPE.getKey(type)) + " is null or not simple.");
    }

    public ParticleDataBuilder.DustParticleDataBuilder dust(int ticks, KubeColor color, Vec3 pos) {
        return this.create(ticks, pos, new ParticleDataBuilder.DustParticleDataBuilder(color, null).color(color));
    }

    public ParticleDataBuilder.DustParticleDataBuilder dust(int ticks, KubeColor fromColor, KubeColor toColor, Vec3 pos) {
        return this.create(ticks, pos, new ParticleDataBuilder.DustParticleDataBuilder(fromColor, toColor).color(fromColor));
    }

    public ParticleDataBuilder.Static item(int ticks, ItemStack item, Vec3 pos) {
        ItemParticleOption options = new ItemParticleOption(ParticleTypes.ITEM, item);
        return this.create(ticks, pos, new ParticleDataBuilder.Static((ParticleOptions)options));
    }

    public ParticleDataBuilder.Static block(int ticks, BlockState blockState, Vec3 pos) {
        BlockParticleOption options = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
        return this.create(ticks, pos, new ParticleDataBuilder.Static((ParticleOptions)options));
    }

    private <O extends ParticleDataBuilder<O, ?>> O create(int ticks, Vec3 origin, O options) {
        this.scene.addInstruction((PonderInstruction)new ParticleInstruction(ticks, origin, options));
        return options;
    }

    public static class ParticleInstruction
    extends TickingInstruction {
        private final ParticleDataBuilder<?, ?> builder;
        private final Vec3 origin;
        private final List<ParticleTransformation> transformations = new ArrayList<ParticleTransformation>();
        private ParticleOptions cachedOptions;

        public ParticleInstruction(int ticks, Vec3 origin, ParticleDataBuilder<?, ?> builder) {
            super(false, ticks);
            this.origin = origin;
            this.builder = builder;
        }

        protected void firstTick(PonderScene scene) {
            this.cachedOptions = this.builder.createOptions();
            this.transformations.clear();
            this.transformations.addAll(this.builder.transformations);
        }

        public void tick(PonderScene scene) {
            try {
                super.tick(scene);
                this.doTick(scene);
            }
            catch (Exception e) {
                PonderErrorHelper.yeet(e);
                this.remainingTicks = 0;
            }
        }

        private void doTick(PonderScene scene) {
            int currentTick = this.totalTicks - this.remainingTicks;
            for (int i = 0; i < this.builder.density; ++i) {
                ParticleTransformation.Data data = new ParticleTransformation.Data(this.origin, Vec3.ZERO);
                for (ParticleTransformation transformation : this.transformations) {
                    float partialTicks = (float)currentTick + (float)i / (float)this.builder.density;
                    data = transformation.apply(partialTicks, data.position(), data.motion());
                }
                Vec3 pos = data.position();
                Vec3 motion = data.motion();
                Particle particle = ((PonderWorldAccessor)scene.getWorld()).ponderjs$makeParticle(this.cachedOptions, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
                if (particle == null) continue;
                this.applyParticleData(particle);
                scene.getWorld().addParticle(particle);
            }
        }

        private void applyParticleData(Particle particle) {
            if (particle instanceof ParticleAccessor) {
                ParticleAccessor accessor = (ParticleAccessor)particle;
                if (this.builder.color != null) {
                    long argb = this.builder.color.kjs$getARGB();
                    float a = (float)(argb >> 24 & 0xFFL) / 255.0f;
                    float r = (float)(argb >> 16 & 0xFFL) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFFL) / 255.0f;
                    float b = (float)(argb & 0xFFL) / 255.0f;
                    particle.setColor(r, g, b);
                    accessor.ponderjs$setAlpha(a);
                }
                if (this.builder.scale != null) {
                    particle.scale(this.builder.scale.floatValue());
                }
                if (this.builder.roll != null) {
                    accessor.ponderjs$setRoll(this.builder.roll.floatValue());
                }
                if (this.builder.friction != null) {
                    accessor.ponderjs$setFriction(this.builder.friction.floatValue());
                }
                if (this.builder.gravity != null) {
                    accessor.ponderjs$setGravity(this.builder.gravity.floatValue());
                }
                if (this.builder.physics != null) {
                    accessor.ponderjs$setHasPhysics(this.builder.physics);
                }
                if (this.builder.collision != null) {
                    accessor.ponderjs$setStoppedByCollision(this.builder.collision);
                }
                if (this.builder.lifetime != null) {
                    accessor.ponderjs$setLifetime(this.builder.lifetime);
                }
            }
        }
    }
}

