/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network.transmitter;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.util.Simulation;
import dev.technici4n.grandpower.api.EnergyStorageUtil;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.swedz.extended_industrialization.machines.component.itemslot.TeslaTowerUpgradeComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaTransferLimits;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.tesseract.neoforge.api.WorldPos;

public class TeslaTransmitterComponent
implements IComponent.ServerOnly,
TeslaTransmitter {
    private final MachineBlockEntity machine;
    private final MIEnergyStorage energyStorage;
    private final Supplier<TeslaTransferLimits> limits;
    private final Supplier<WorldPos> sourcePosition;
    private Optional<WorldPos> networkKey = Optional.empty();

    public TeslaTransmitterComponent(MachineBlockEntity machine, final List<EnergyComponent> energyInputs, Supplier<TeslaTransferLimits> limits, Supplier<WorldPos> sourcePosition) {
        this.machine = machine;
        this.energyStorage = new MIEnergyStorage.NoInsert(){

            public boolean canConnect(CableTier cableTier) {
                return false;
            }

            public long extract(long maxExtract, boolean simulate) {
                long extracted = 0L;
                for (EnergyComponent energyComponent : energyInputs) {
                    long remaining = maxExtract - extracted;
                    if (remaining == 0L) break;
                    extracted += energyComponent.consumeEu(remaining, simulate ? Simulation.SIMULATE : Simulation.ACT);
                }
                return extracted;
            }

            public long getAmount() {
                return energyInputs.stream().mapToLong(EnergyComponent::getEu).sum();
            }

            public long getCapacity() {
                return energyInputs.stream().mapToLong(EnergyComponent::getCapacity).sum();
            }

            public boolean canExtract() {
                return true;
            }
        };
        this.limits = limits;
        this.sourcePosition = sourcePosition;
    }

    public TeslaTransmitterComponent(MachineBlockEntity machine, List<EnergyComponent> energyInputs, Supplier<TeslaTransferLimits> limits) {
        this(machine, energyInputs, limits, () -> new WorldPos(machine.getLevel(), machine.getBlockPos()));
    }

    @Override
    public boolean hasNetwork() {
        return this.networkKey.isPresent();
    }

    @Override
    public WorldPos getNetworkKey() {
        return this.networkKey.orElseThrow();
    }

    @Override
    public void setNetwork(WorldPos key) {
        this.networkKey = Optional.ofNullable(key);
    }

    @Override
    public WorldPos getPosition() {
        return new WorldPos(this.machine.getLevel(), this.machine.getBlockPos());
    }

    @Override
    public WorldPos getSourcePosition() {
        return this.sourcePosition.get();
    }

    @Override
    public CableTier getCableTier() {
        return this.limits.get().getCableTier();
    }

    @Override
    public long getMaxTransfer() {
        return this.limits.get().getMaxTransfer();
    }

    @Override
    public int getMaxDistance() {
        return this.limits.get().getMaxDistance();
    }

    @Override
    public long getPassiveDrain() {
        return this.limits.get().getPassiveDrain();
    }

    @Override
    public boolean isInterdimensional() {
        return (Boolean)this.machine.components.mapOrDefault(TeslaTowerUpgradeComponent.class, TeslaTowerUpgradeComponent::isInterdimensional, (Object)false);
    }

    @Override
    public long transmitEnergy(long maxTransmit) {
        if (this.hasNetwork()) {
            TeslaNetwork network = this.getNetwork();
            return EnergyStorageUtil.move((ILongEnergyStorage)this.energyStorage, (ILongEnergyStorage)network, (long)maxTransmit);
        }
        return 0L;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        return this.energyStorage.extract(maxExtract, simulate);
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
    }
}

