/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.nanosuit;

import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.api.energy.CableTier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIArmorMaterials;
import net.swedz.extended_industrialization.item.ElectricArmorItem;
import net.swedz.extended_industrialization.item.ToggleableItem;
import net.swedz.extended_industrialization.item.nanosuit.ability.NanoSuitAbility;
import net.swedz.extended_industrialization.item.nanosuit.decoration.NanoSuitDecoration;
import net.swedz.tesseract.neoforge.helper.ColorHelper;
import net.swedz.tesseract.neoforge.item.ArmorTickHandler;
import net.swedz.tesseract.neoforge.item.ArmorUnequippedHandler;
import net.swedz.tesseract.neoforge.item.DynamicDyedItem;
import net.swedz.tesseract.neoforge.item.ItemHurtHandler;

public final class NanoSuitArmorItem
extends ElectricArmorItem
implements ArmorTickHandler,
ArmorUnequippedHandler,
ItemHurtHandler,
ToggleableItem,
DynamicDyedItem {
    private static final long DEFAULT_ENERGY_CAPACITY = 1200L * CableTier.MV.getMaxTransfer();
    private static final long DAMAGE_ENERGY = 1024L;
    private final Optional<NanoSuitAbility> ability;
    private final boolean quantum;

    public NanoSuitArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, Optional<NanoSuitAbility> ability, boolean quantum) {
        super(material, type, properties, ability.map(NanoSuitAbility::overrideEnergyCapacity).filter(e -> e > 0L).orElse(DEFAULT_ENERGY_CAPACITY), 1024L);
        if (ability.isPresent() && type != ability.get().armorType()) {
            throw new IllegalArgumentException("Mismatching armor type for item and ability");
        }
        this.ability = ability;
        this.quantum = quantum;
    }

    public Optional<NanoSuitAbility> ability() {
        return this.ability;
    }

    public boolean hasAbility(Class<? extends NanoSuitAbility> abilityClass) {
        return this.ability.filter(a -> abilityClass.isAssignableFrom(a.getClass())).isPresent();
    }

    public boolean isQuantum() {
        return this.quantum;
    }

    public List<NanoSuitDecoration> decorations(ItemStack stack) {
        ArrayList decorations = Lists.newArrayList();
        for (NanoSuitDecoration decoration : NanoSuitDecoration.values()) {
            if (decoration.armorType() != this.type || stack != null && !decoration.isActiveFor(this, stack)) continue;
            decorations.add(decoration);
        }
        return Collections.unmodifiableList(decorations);
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return !this.quantum && super.isBarVisible(stack);
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return this.quantum ? 0L : super.getEnergyCapacity(stack);
    }

    @Override
    public boolean hasEnergy(ItemStack stack) {
        return this.quantum || super.hasEnergy(stack);
    }

    @Override
    public ItemAttributeModifiers getModifiedDefaultAttributeModifiers(ItemStack stack, ItemAttributeModifiers modifiers) {
        if (this.ability.isPresent()) {
            NanoSuitAbility ability = this.ability.get();
            modifiers = ability.getModifiedDefaultAttributeModifiers(this, stack, modifiers);
        }
        if (this.quantum) {
            modifiers = modifiers.withModifierAdded(MIRegistries.QUANTUM_ARMOR, new AttributeModifier(EI.id("nano_quantum_armor_%s".formatted(this.type.getName())), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
        }
        return modifiers;
    }

    public int getDyeColor(DyeColor dyeColor) {
        return ColorHelper.getVibrantColor((DyeColor)dyeColor);
    }

    public int getDefaultDyeColor() {
        return this.ability.map(NanoSuitAbility::overrideDefaultColor).orElse(EIArmorMaterials.NANO_COLOR);
    }

    @Override
    public boolean getDefaultActivatedState() {
        return true;
    }

    @Override
    public void setActivated(Player player, ItemStack stack, boolean activated) {
        this.ability.ifPresent(ability -> {
            ToggleableItem.super.setActivated(player, stack, activated);
            if (!player.level().isClientSide()) {
                ability.onActivationChange(this, player, stack, activated);
            }
        });
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.ability.isPresent() && action == ClickAction.SECONDARY && other.isEmpty()) {
            this.setActivated(player, stack, !this.isActivated(stack));
            if (player.level().isClientSide()) {
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    public void armorTick(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        if (entity.level().isClientSide()) {
            return;
        }
        this.ability.ifPresent(ability -> ability.tick(this, entity, slot, stack));
    }

    public void onUnequipArmor(LivingEntity entity, EquipmentSlot slot, ItemStack fromStack, ItemStack toStack) {
        if (!ItemStack.isSameItem((ItemStack)fromStack, (ItemStack)toStack)) {
            this.ability.ifPresent(ability -> ability.onUnequip(this, entity, slot, fromStack, toStack));
        }
    }

    public String getDescriptionId(ItemStack stack) {
        for (NanoSuitDecoration decoration : this.decorations(stack)) {
            String descriptionId = decoration.getDescriptionId(this, stack);
            if (descriptionId == null) continue;
            return descriptionId;
        }
        return super.getDescriptionId(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        for (NanoSuitDecoration decoration : this.decorations(stack)) {
            decoration.getTooltipLines(this, stack).ifPresent(tooltip::addAll);
        }
        this.ability.flatMap(a -> a.getTooltipLines(this, stack)).ifPresent(tooltip::addAll);
    }
}

