/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetworkCache;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetworkPart;
import net.swedz.tesseract.neoforge.api.WorldPos;

@EventBusSubscriber(modid="extended_industrialization")
public final class EICommands {
    @SubscribeEvent
    private static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ei").requires(s -> s.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"tesla_network").then(Commands.literal((String)"dump").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> EICommands.teslaNetworkDump((CommandSourceStack)context.getSource(), new WorldPos((Level)DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos")))))))).then(Commands.literal((String)"dump_at").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> EICommands.teslaNetworkDumpAt((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos")))))));
    }

    private static void teslaNetworkDump(CommandSourceStack source, TeslaNetwork network, BlockPos pos) {
        MutableComponent transmitterResult;
        source.sendSuccess(() -> EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_1.text(new Object[]{pos.toShortString()}), true);
        source.sendSuccess(() -> EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_2.text(new Object[]{"%s (%s)".formatted(network.key().pos().toShortString(), network.key().dimension().location().toString())}), true);
        if (network.hasTransmitter()) {
            WorldPos transmitterPosition = network.getTransmitter().getPosition();
            boolean ticking = network.isTransmitterLoaded();
            transmitterResult = EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_YES_TRANSMITTER.text(new Object[]{"%s (%s)".formatted(transmitterPosition.pos().toShortString(), transmitterPosition.dimension().location().toString()), Boolean.toString(ticking), ticking ? network.getCableTier().shortEnglishName() : Component.literal((String)"N/A")});
        } else {
            transmitterResult = EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_NO_TRANSMITTER.text();
        }
        source.sendSuccess(() -> EICommands.lambda$teslaNetworkDump$5((Component)transmitterResult), true);
        source.sendSuccess(() -> EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_4.text(new Object[]{network.receiverCount(), network.loadedReceiverCount()}), true);
    }

    private static int teslaNetworkDump(CommandSourceStack source, WorldPos pos) {
        ServerLevel level = pos.level();
        TeslaNetworkCache cache = level.getServer().getTeslaNetworks();
        if (cache.exists(pos)) {
            TeslaNetwork network = cache.get(pos);
            EICommands.teslaNetworkDump(source, network, pos.pos());
        } else {
            source.sendFailure((Component)EIText.COMMAND_TESLA_NETWORK_DUMP_NO_NETWORK.text(new Object[]{"%s (%s)".formatted(pos.pos().toShortString(), pos.dimension().location().toString())}));
        }
        return 1;
    }

    private static int teslaNetworkDumpAt(CommandSourceStack source, BlockPos pos) {
        ServerLevel level = source.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeslaNetworkPart) {
            TeslaNetworkPart networkPart = (TeslaNetworkPart)blockEntity;
            if (networkPart.hasNetwork()) {
                TeslaNetwork network = networkPart.getNetwork();
                EICommands.teslaNetworkDump(source, network, pos);
            } else {
                source.sendFailure((Component)EIText.COMMAND_TESLA_NETWORK_DUMP_NO_NETWORK.text(new Object[]{pos.toShortString()}));
            }
        } else {
            source.sendFailure((Component)EIText.COMMAND_TESLA_NETWORK_DUMP_CANT_HAVE_NETWORK.text(new Object[]{pos.toShortString()}));
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$teslaNetworkDump$5(Component transmitterResult) {
        return EIText.COMMAND_TESLA_NETWORK_DUMP_RESULT_3.text(new Object[]{transmitterResult});
    }
}

