/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.util.Lazy;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.item.ToggleableItem;
import net.swedz.extended_industrialization.network.packet.ToggleToggleableItemPacket;

public final class EIKeybinds {
    public static final String CATEGORY = Util.makeDescriptionId((String)"key.categories", (ResourceLocation)EI.id("extended_industrialization"));
    public static final Keybind TOGGLE_MAIN_HAND_ABILITY = EIKeybinds.create("toggle_main_hand_ability", "Toggle Main Hand Ability", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, CATEGORY), EIKeybinds.toggleableItemAction(EquipmentSlot.MAINHAND));
    public static final Keybind TOGGLE_HELMET_ABILITY = EIKeybinds.create("toggle_helmet_ability", "Toggle Helmet Ability", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, CATEGORY), EIKeybinds.toggleableItemAction(EquipmentSlot.HEAD));
    public static final Keybind TOGGLE_CHESTPLATE_ABILITY = EIKeybinds.create("toggle_chestplate_ability", "Toggle Chestplate Ability", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, CATEGORY), EIKeybinds.toggleableItemAction(EquipmentSlot.CHEST));
    public static final Keybind TOGGLE_LEGGINGS_ABILITY = EIKeybinds.create("toggle_leggings_ability", "Toggle Leggings Ability", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, CATEGORY), EIKeybinds.toggleableItemAction(EquipmentSlot.LEGS));
    public static final Keybind TOGGLE_BOOTS_ABILITY = EIKeybinds.create("toggle_boots_ability", "Toggle Boots Ability", id -> new KeyMapping(id, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, CATEGORY), EIKeybinds.toggleableItemAction(EquipmentSlot.FEET));

    public static void init(RegisterKeyMappingsEvent event) {
        Registry.init(event);
    }

    public static void init(IEventBus bus) {
        bus.addListener(RegisterKeyMappingsEvent.class, EIKeybinds::init);
    }

    private static Keybind create(String id, String englishName, Function<String, KeyMapping> creator, Runnable action) {
        String descriptionId = Util.makeDescriptionId((String)"key", (ResourceLocation)EI.id(id));
        Keybind keybind = new Keybind(descriptionId, englishName, (Lazy<KeyMapping>)Lazy.of(() -> (KeyMapping)creator.apply(descriptionId)), action);
        Registry.include(keybind);
        return keybind;
    }

    private static Runnable toggleableItemAction(EquipmentSlot slot) {
        return () -> {
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack stack = player.getItemBySlot(slot);
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof ToggleableItem) {
                ToggleableItem item = (ToggleableItem)patt0$temp;
                boolean activated = !item.isActivated(stack);
                item.setActivated((Player)player, stack, activated);
                new ToggleToggleableItemPacket(slot, activated).sendToServer();
            }
        };
    }

    public static final class Registry {
        private static final Set<Keybind> MAPPINGS = Sets.newHashSet();

        private static void init(RegisterKeyMappingsEvent event) {
            MAPPINGS.forEach(m -> event.register((KeyMapping)m.holder().get()));
        }

        private static void include(Keybind mapping) {
            MAPPINGS.add(mapping);
        }

        public static Set<Keybind> getMappings() {
            return Collections.unmodifiableSet(MAPPINGS);
        }
    }

    public record Keybind(String descriptionId, String englishName, Lazy<KeyMapping> holder, Runnable action) {
    }
}

