/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.api.energy.CableTier;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.Map;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MICodecs;
import net.swedz.tesseract.neoforge.config.annotation.ConfigComment;
import net.swedz.tesseract.neoforge.config.annotation.ConfigKey;
import net.swedz.tesseract.neoforge.config.annotation.Range;
import net.swedz.tesseract.neoforge.config.annotation.SubSection;

public interface EIConfig {
    @ConfigKey(value="machine_chainer_max_connections")
    @ConfigComment(value={"The maximum amount of connections a machine chainer can have"})
    @Range.Integer(min=1, max=128)
    default public int machineChainerMaxConnections() {
        return 64;
    }

    @ConfigKey(value="allow_upgrades_in_processing_array")
    @ConfigComment(value={"Whether upgrades should be allowed in the Processing Array"})
    default public boolean allowUpgradesInProcessingArray() {
        return true;
    }

    @ConfigKey(value="farmer_fertilizer_max_random_ticks")
    @ConfigComment(value={"The maximum amount of random ticks the farmer can do on a crop block in a single use of fertilizer"})
    @Range.Integer(min=1, max=1000)
    default public int farmerFertilizerMaxRandomTicks() {
        return 80;
    }

    @ConfigKey(value="tesla_coil_range")
    @ConfigComment(value={"The range for the tesla coil to transmit energy within"})
    @Range.Integer(min=1, max=0x7FFFFFFF)
    default public int teslaCoilRange() {
        return 32;
    }

    @ConfigKey(value="lethal_tesla_coil")
    @SubSection
    public LethalTeslaCoil lethalTeslaCoil();

    @ConfigKey(value="batching_machines")
    @SubSection
    public BatchingMachines batchingMachines();

    @ConfigKey(value="runtime_generated_recipes")
    @SubSection
    public RuntimeGeneratedRecipes runtimeGeneratedRecipes();

    public static final class CableTierDamages {
        public static final Codec<CableTierDamages> CODEC = Codec.unboundedMap((Codec)MICodecs.CABLE_TIER, (Codec)Codec.doubleRange((double)0.1, (double)2.147483647E9)).xmap(CableTierDamages::new, value -> value.damages);
        private final Map<CableTier, Double> damages;

        private CableTierDamages(Map<CableTier, Double> damages) {
            this.damages = Collections.unmodifiableMap(damages);
        }

        public double get(CableTier cableTier) {
            Assert.notNull((Object)cableTier);
            return this.damages.getOrDefault(cableTier, (double)cableTier.eu / 16.0);
        }
    }

    public static interface RuntimeGeneratedRecipes {
        @ConfigKey(value="canning_machine")
        @ConfigComment(value={"Whether canning machine recipes should be generated automatically at runtime or not"})
        default public boolean canningMachine() {
            return true;
        }

        @ConfigKey(value="composter")
        @ConfigComment(value={"Whether composter recipes should be generated automatically at runtime or not"})
        default public boolean composter() {
            return true;
        }
    }

    public static interface BatchingMachines {
        @ConfigKey(value="large_steam_macerator_size")
        @ConfigComment(value={"The maximum batch size to use for the Large Steam Macerator"})
        @Range.Integer(min=1, max=0x7FFFFFFF)
        default public int largeSteamMaceratorSize() {
            return 8;
        }

        @ConfigKey(value="large_steam_macerator_eu")
        @ConfigComment(value={"The multiplier to use for the EU cost of the Large Steam Macerator"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double largeSteamMaceratorEU() {
            return 0.75;
        }

        @ConfigKey(value="large_steam_furnace_size")
        @ConfigComment(value={"The maximum batch size to use for the Large Steam Furnace"})
        @Range.Integer(min=1, max=0x7FFFFFFF)
        default public int largeSteamFurnaceSize() {
            return 8;
        }

        @ConfigKey(value="large_steam_furnace_eu")
        @ConfigComment(value={"The multiplier to use for the EU cost of the Large Steam Furnace"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double largeSteamFurnaceEU() {
            return 0.75;
        }

        @ConfigKey(value="large_electric_macerator_size")
        @ConfigComment(value={"The maximum batch size to use for the Large Electric Macerator"})
        @Range.Integer(min=1, max=0x7FFFFFFF)
        default public int largeElectricMaceratorSize() {
            return 16;
        }

        @ConfigKey(value="large_electric_macerator_eu")
        @ConfigComment(value={"The multiplier to use for the EU cost of the Large Electric Macerator"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double largeElectricMaceratorEU() {
            return 0.75;
        }

        @ConfigKey(value="processing_array_eu")
        @ConfigComment(value={"The multiplier to use for the EU cost of the Processing Array"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double processingArrayEU() {
            return 1.0;
        }
    }

    public static interface LethalTeslaCoil {
        @ConfigKey(value="range")
        @ConfigComment(value={"The range for the lethal tesla coil to damage entities within"})
        @Range.Integer(min=1, max=0x7FFFFFFF)
        default public int range() {
            return 2;
        }

        @ConfigKey(value="damage")
        @ConfigComment(value={"The amount of damage dealt by the lethal tesla coil for a cable tier", "If no value is specified for a cable tier, the cable tier's EU value is divided by 16 to determine the damage dealt", "Range: >= 0.1"})
        default public CableTierDamages damage() {
            return new CableTierDamages(Map.of(CableTier.SUPERCONDUCTOR, 2.147483647E9));
        }
    }
}

