/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.entity.ChunkloaderEntity;
import es.degrassi.mmreborn.common.util.ChunkloaderList;
import es.degrassi.mmreborn.common.util.TaskDelayer;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class Chunkloader
implements INBTSerializable<CompoundTag> {
    private final ChunkloaderEntity entity;
    private int radius;
    private int tempo = -1;
    private boolean active;
    private static final TicketType<BlockPos> MACHINE_CHUNKLOADER = TicketType.create((String)"chunkloader", Vec3i::compareTo, (int)0);

    public Chunkloader(ChunkloaderEntity entity, int radius, boolean active) {
        this.active = active;
        this.radius = radius;
        this.entity = entity;
    }

    public Chunkloader(ChunkloaderEntity entity) {
        this(entity, 1, false);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("active", this.active);
        nbt.putInt("radius", this.radius);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("active", 1)) {
            this.active = nbt.getBoolean("active");
        }
        if (nbt.contains("radius", 3)) {
            this.radius = nbt.getInt("radius");
        }
    }

    public void setActive(ServerLevel level, int radius) {
        if (this.active) {
            this.setInactive(level);
        }
        this.active = true;
        this.radius = radius;
        BlockPos machinePos = this.getEntity().getBlockPos();
        ChunkPos chunk = new ChunkPos(machinePos);
        level.setChunkForced(chunk.x, chunk.z, true);
        level.getChunkSource().addRegionTicket(MACHINE_CHUNKLOADER, chunk, radius + 1, (Object)machinePos);
    }

    public void setActiveWithTempo(ServerLevel level, int radius, int tempo) {
        this.tempo = Math.max(this.tempo, tempo);
        if (!this.active || this.radius < radius) {
            this.setActive(level, radius);
        }
    }

    public void setInactive(ServerLevel level) {
        this.active = false;
        BlockPos machinePos = this.getEntity().getBlockPos();
        ChunkPos chunk = new ChunkPos(machinePos);
        if (ChunkloaderList.findInSameChunk(this.getEntity()).isEmpty()) {
            level.setChunkForced(chunk.x, chunk.z, false);
        }
        level.getChunkSource().removeRegionTicket(MACHINE_CHUNKLOADER, chunk, this.radius + 1, (Object)machinePos);
    }

    public void serverTick() {
        if (this.tempo >= 0 && this.tempo-- == 0) {
            this.setInactive((ServerLevel)this.getEntity().getLevel());
        }
    }

    public void onRemoved() {
        Level level = this.getEntity().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!this.getEntity().isUnloaded()) {
                this.setInactive(level2);
            }
        }
    }

    public void init() {
        Level level;
        if (this.active && (level = this.getEntity().getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos pos = new ChunkPos(this.getEntity().getBlockPos());
            if (level2.getChunk(pos.x, pos.z, ChunkStatus.EMPTY, false) instanceof LevelChunk) {
                this.setActive(level2, this.radius);
            } else {
                TaskDelayer.enqueue(1, () -> this.setActive(level2, this.radius));
            }
        }
    }

    @Generated
    public ChunkloaderEntity getEntity() {
        return this.entity;
    }

    @Generated
    public int getRadius() {
        return this.radius;
    }

    @Generated
    public int getTempo() {
        return this.tempo;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }
}

