/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemComponent
extends MachineComponent<IOInventory> {
    private final IOInventory handler;

    public ItemComponent(IOInventory handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_ITEM.get();
    }

    @Override
    public IOInventory getContainerProvider() {
        return this.handler;
    }

    public int getIngredientAmount(Ingredient ingredient) {
        return this.handler.getInputs().stream().filter(component -> ingredient.test(component.getItemStack())).mapToInt(component -> component.getItemStack().getCount()).sum();
    }

    public int getItemAmount(ItemStack stack) {
        return this.handler.getItemAmount(stack);
    }

    public int getSpaceForItem(ItemStack stack) {
        return this.handler.getSpaceForItem(stack);
    }

    public void removeFromInputs(Ingredient ingredient, int amount) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        this.handler.getInputs().stream().filter(component -> ingredient.test(component.getItemStack())).forEach(component -> {
            int maxExtract = Math.min(component.getItemStack().getCount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.getItemStack().shrink(maxExtract);
        });
    }

    public void addToOutputs(ItemStack stack, int amount) {
        this.handler.addToOutputs(stack, amount);
    }

    @Override
    public CompoundTag asTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.asTag(provider);
        tag.put("handler", (Tag)this.handler.writeNBT(provider));
        return tag;
    }

    @Override
    public <C extends MachineComponent<?>> C merge(C c) {
        ItemComponent comp = (ItemComponent)c;
        return (C)new ItemComponent(IOInventory.mergeBuild(this.handler, comp.handler), this.getIOType());
    }
}

