/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.entity.EnergyInputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.EnergyComponent;
import es.degrassi.mmreborn.common.network.server.component.SUpdateEnergyComponentPacket;
import es.degrassi.mmreborn.common.util.IEnergyHandler;
import es.degrassi.mmreborn.common.util.MiscUtils;
import java.util.Locale;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class EnergyHatchEntity
extends ColorableMachineComponentEntity
implements IEnergyHandler,
MachineComponentEntity<EnergyComponent>,
ControllerAccessible {
    protected long energy = 0L;
    protected EnergyHatchSize size;
    protected IOType ioType;
    private BlockPos controllerPos;
    private boolean canExtract = false;
    private boolean canInsert = false;

    public EnergyHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, EnergyHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.size = size;
        this.ioType = ioType;
    }

    @Override
    @Nullable
    public EnergyComponent provideComponent() {
        return new EnergyComponent(this, this.ioType);
    }

    @Override
    public void setCanExtract(boolean canExtract) {
        this.canExtract = canExtract;
    }

    @Override
    public void setCanInsert(boolean canInsert) {
        this.canInsert = canInsert;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int insertable = this.energy + (long)maxReceive > this.size.maxEnergy ? this.convertDownEnergy(this.size.maxEnergy - this.energy) : maxReceive;
        insertable = Math.min(insertable, this.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            Level level;
            this.energy = MiscUtils.clamp(this.energy + (long)insertable, 0L, this.size.maxEnergy);
            this.markForUpdate();
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
            if ((level = this.getLevel()) instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return insertable;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extractable = this.energy - (long)maxExtract < 0L ? this.convertDownEnergy(this.energy) : maxExtract;
        extractable = Math.min(extractable, this.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            this.energy = MiscUtils.clamp(this.energy - (long)extractable, 0L, this.size.maxEnergy);
            if (this.getController() != null) {
                this.getController().getProcessor().setMachineInventoryChanged();
            }
            this.markForUpdate();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return extractable;
    }

    public int getEnergyStored() {
        return this.convertDownEnergy(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.convertDownEnergy(this.size.maxEnergy);
    }

    public boolean canExtract() {
        return this.canExtract || this.ioType != null && !this.ioType.isInput();
    }

    public boolean canReceive() {
        return this.canInsert || this.ioType != null && this.ioType.isInput();
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.energy = compound.getLong("energy");
        this.ioType = IOType.getByString(compound.getString("ioType"));
        this.size = EnergyHatchSize.value(compound.getString("hatchSize").toUpperCase(Locale.ROOT));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        if (this.getController() != null) {
            this.getController().getProcessor().setMachineInventoryChanged();
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putLong("energy", this.energy);
        if (this.ioType == null) {
            this.ioType = this instanceof EnergyInputHatchEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        compound.putString("hatchSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    protected int convertDownEnergy(long energy) {
        return energy >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    public EnergyHatchSize getTier() {
        return this.size;
    }

    @Override
    public long getCurrentEnergy() {
        return this.energy;
    }

    @Override
    public void setCurrentEnergy(long energy) {
        this.energy = MiscUtils.clamp(energy, 0L, this.getMaxEnergy());
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.getController() != null) {
            this.getController().getProcessor().setMachineInventoryChanged();
        }
        this.markForUpdate();
    }

    @Override
    public long getMaxEnergy() {
        return this.size.maxEnergy;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }
}

