/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.WeatherType;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.WeatherComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class RequirementWeather
implements IRequirement<WeatherComponent> {
    public static final NamedCodec<RequirementWeather> CODEC = NamedCodec.record(instance -> instance.group(WeatherType.CODEC.fieldOf("weather").forGetter(RequirementWeather::weather), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, RequirementWeather::new), "Weather Requirement");
    private final WeatherType weather;
    private final PositionedRequirement position;

    public RequirementWeather(WeatherType filter, PositionedRequirement position) {
        this.weather = filter;
        this.position = position;
    }

    public WeatherType weather() {
        return this.weather;
    }

    @Override
    public RequirementType<RequirementWeather> getType() {
        return RequirementTypeRegistration.WEATHER.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_WEATHER.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(WeatherComponent component, ICraftingContext context) {
        Level world = context.getMachineTile().getLevel();
        BlockPos pos = context.getMachineTile().getBlockPos();
        if (world == null) {
            return false;
        }
        return switch (this.weather) {
            default -> throw new MatchException(null, null);
            case WeatherType.RAIN -> world.isRaining();
            case WeatherType.SNOW -> {
                if (world.isRaining() && world.canSeeSky(pos.above()) && world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos.above()).getY() > pos.above().getY() && ((Biome)world.getBiome(pos).value()).coldEnoughToSnow(pos.above())) {
                    yield true;
                }
                yield false;
            }
            case WeatherType.THUNDER -> world.isThundering();
            case WeatherType.CLEAR -> !world.isRaining();
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<WeatherComponent> list) {
        list.worldCondition(this::check);
    }

    public CraftingResult check(WeatherComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.weather", (Object[])new Object[]{this.weather.name().toLowerCase(Locale.ROOT)}));
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.weather");
    }

    @Override
    public boolean isComponentValid(WeatherComponent m, ICraftingContext context) {
        return this.getMode().equals((Object)m.getIOType());
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

