/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockExperienceHatch;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.entity.ExperienceInputHatchEntity;
import es.degrassi.mmreborn.common.item.ExperienceHatchItem;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockExperienceInputHatch
extends BlockExperienceHatch {
    public BlockExperienceInputHatch(ExperienceHatchSize size) {
        super(size);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ExperienceInputHatchEntity(blockPos, blockState, this.size);
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        switch (this.size) {
            case TINY: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_TINY.get()).getDefaultInstance());
                break;
            }
            case SMALL: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_SMALL.get()).getDefaultInstance());
                break;
            }
            case NORMAL: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_NORMAL.get()).getDefaultInstance());
                break;
            }
            case REINFORCED: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_REINFORCED.get()).getDefaultInstance());
                break;
            }
            case BIG: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_BIG.get()).getDefaultInstance());
                break;
            }
            case HUGE: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_HUGE.get()).getDefaultInstance());
                break;
            }
            case LUDICROUS: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_LUDICROUS.get()).getDefaultInstance());
                break;
            }
            case VACUUM: {
                drops.add(((ExperienceHatchItem)ItemRegistration.EXPERIENCE_INPUT_HATCH_VACUUM.get()).getDefaultInstance());
            }
        }
        return drops;
    }
}

