/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.entity.DimensionalDetectorEntity;
import es.degrassi.mmreborn.common.item.DimensionalDetectorItem;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockDimensionDetector
extends BlockMachineComponent {
    public BlockDimensionDetector() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 10.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().dynamicShape().noOcclusion());
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        drops.add(((DimensionalDetectorItem)ItemRegistration.DIMENSIONAL_DETECTOR.get()).getDefaultInstance());
        return drops;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new DimensionalDetectorEntity(pos, state);
    }
}

