/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen<T extends ContainerBase<E>, E extends ColorableMachineComponentEntity>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation BASE_SLOT = ModularMachineryReborn.rl("textures/gui/base_slot.png");
    public static final ResourceLocation BASE_SLOT_HOVERED = ModularMachineryReborn.rl("textures/gui/base_slot_hovered.png");
    public static final ResourceLocation TAB = ModularMachineryReborn.rl("textures/gui/widget/base_tab.png");
    public static final ResourceLocation TAB_HOVERED = ModularMachineryReborn.rl("textures/gui/widget/base_tab_hovered.png");
    protected final E entity;

    public BaseScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.entity = ((ContainerBase)((Object)menu)).getEntity();
    }

    @Nullable
    public abstract ResourceLocation getTexture();

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        int i = this.leftPos;
        int j = this.topPos;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.disableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)i, (float)j, 0.0f);
        this.hoveredSlot = null;
        for (int k = 0; k < ((ContainerBase)this.menu).slots.size(); ++k) {
            Slot slot = (Slot)((ContainerBase)this.menu).slots.get(k);
            if (!slot.isActive()) continue;
            this.renderSlot(guiGraphics, slot);
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            this.hoveredSlot = slot;
            this.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTick);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((ContainerBase)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int l1 = 8;
            int i2 = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        if (!this.snapbackItem.isEmpty()) {
            float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int j2 = this.snapbackEnd.x - this.snapbackStartX;
            int k2 = this.snapbackEnd.y - this.snapbackStartY;
            int j1 = this.snapbackStartX + (int)((float)j2 * f);
            int k1 = this.snapbackStartY + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, j1, k1, null);
        }
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        if (this.getTexture() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            guiGraphics.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            guiGraphics.pose().popPose();
        }
    }

    protected void renderSlotHighlight(GuiGraphics guiGraphics, Slot slot, int mouseX, int mouseY, float partialTick) {
        if (slot.isHighlightable()) {
            BaseScreen.renderSlotHighlight(guiGraphics, slot.x, slot.y, this.getSlotColor(slot.index));
        }
    }

    public static void renderSlotHighlight(GuiGraphics guiGraphics, int x, int y, int color) {
        guiGraphics.pose().pushPose();
        int width = TextureSizeHelper.getWidth(BASE_SLOT_HOVERED);
        int height = TextureSizeHelper.getHeight(BASE_SLOT_HOVERED);
        guiGraphics.blit(BASE_SLOT_HOVERED, x - 1, y - 1, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 16, y + 16, color, color, 0);
        guiGraphics.pose().popPose();
    }
}

