/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.requirement;

import dev.emi.emi.runtime.EmiDrawContext;
import es.degrassi.mmreborn.common.crafting.requirement.emi.Position;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public interface ChanceRendering
extends Position {
    public static final Minecraft CLIENT = Minecraft.getInstance();

    public float getChance();

    public IOType getActionType();

    default public void drawChance(GuiGraphics graphics, boolean top) {
        MutableComponent component = Component.empty();
        String c = Utils.decimalFormat(this.getChance() * 100.0f);
        if (this.getChance() > 0.0f && this.getChance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{c, "%"});
        } else if (this.getChance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc");
        }
        int xOff = (this.getWidth() - 16) / 2 + 2;
        int yOff = (this.getHeight() - 16) / 2;
        int modifier = top ? -1 : 1;
        yOff *= modifier;
        int modified = top ? 1 : 2;
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)graphics);
        ChanceRendering.renderAmount(context, xOff, yOff += modified, top, (Component)component);
    }

    private static void renderAmount(EmiDrawContext context, int x, int y, boolean top, Component amount) {
        int n;
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        context.matrices().scale(0.75f, 0.75f, 0.75f);
        int tx = x + 17 - Math.min(14, ChanceRendering.CLIENT.font.width((FormattedText)amount));
        if (top) {
            n = 0;
        } else {
            Objects.requireNonNull(ChanceRendering.CLIENT.font);
            n = 9 * 3 / 2;
        }
        context.drawTextWithShadow(amount, tx, y += n, Config.chanceColor);
        context.pop();
    }

    default public void addChanceTooltips(List<Component> list) {
        String chance = Utils.decimalFormat(this.getChance() * 100.0f);
        if (this.getChance() > 0.0f && this.getChance() < 1.0f) {
            list.add((Component)Component.translatable((String)("modular_machinery_reborn.ingredient.chance." + this.getActionType().name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{chance, "%"}));
        } else if (this.getChance() == 0.0f) {
            list.add((Component)Component.translatable((String)"modular_machinery_reborn.ingredient.chance.not_consumed"));
        } else if (this.getChance() == 1.0f) {
            list.add((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.item." + this.getActionType().name().toLowerCase(Locale.ROOT))));
        }
    }
}

