/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.ClientScheduler;
import es.degrassi.mmreborn.client.entity.renderer.ControllerRenderer;
import es.degrassi.mmreborn.client.integration.emi.MMREmiClientIntegration;
import es.degrassi.mmreborn.client.integration.jei.MMRJeiClientIntegration;
import es.degrassi.mmreborn.client.item.MMRItemTooltip;
import es.degrassi.mmreborn.client.item.MMRItemTooltipComponent;
import es.degrassi.mmreborn.client.model.ControllerModelLoader;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.EnergyHatchScreen;
import es.degrassi.mmreborn.client.screen.ExperienceHatchScreen;
import es.degrassi.mmreborn.client.screen.FluidHatchScreen;
import es.degrassi.mmreborn.client.screen.ItemBusScreen;
import es.degrassi.mmreborn.client.screen.ParallelHatchScreen;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.ParallelHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.entity.base.FluidTankEntity;
import es.degrassi.mmreborn.common.entity.base.TileItemBus;
import es.degrassi.mmreborn.common.item.ItemDynamicColor;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.common.util.Mods;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="modular_machinery_reborn", dist={Dist.CLIENT})
public class ModularMachineryRebornClient {
    public static final ClientScheduler clientScheduler = new ClientScheduler();
    private static Map<ModelResourceLocation, BakedModel> models;
    private static final List<Block> blockModelsToRegister;
    private static final List<Item> itemModelsToRegister;
    private final IEventBus bus;

    public ModularMachineryRebornClient(IEventBus bus) {
        NeoForge.EVENT_BUS.register((Object)clientScheduler);
        bus.register((Object)this);
        this.bus = bus;
    }

    @SubscribeEvent
    public void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(EntityRegistration.CONTROLLER.get(), ControllerRenderer::new);
    }

    @SubscribeEvent
    public void registerModelLoader(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ModularMachineryReborn.rl("controller"), (IGeometryLoader)ControllerModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(MMRItemTooltipComponent.class, c -> new MMRItemTooltip(c.getItem(), c.getComponent(), c.isCompleted()));
    }

    @SubscribeEvent
    public void onBackingCompleted(ModelEvent.BakingCompleted event) {
        models = event.getModels();
    }

    public static Map<ModelResourceLocation, BakedModel> getAllModels() {
        return models;
    }

    @SubscribeEvent
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(ModularMachineryRebornClient::blockColor, new Block[]{(Block)BlockRegistration.CONTROLLER.get(), (Block)BlockRegistration.CASING_PLAIN.get(), (Block)BlockRegistration.CASING_VENT.get(), (Block)BlockRegistration.CASING_FIREBOX.get(), (Block)BlockRegistration.CASING_GEARBOX.get(), (Block)BlockRegistration.CASING_REINFORCED.get(), (Block)BlockRegistration.CASING_CIRCUITRY.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_TINY.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_SMALL.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_BIG.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_HUGE.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.ENERGY_INPUT_HATCH_ULTIMATE.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_TINY.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_SMALL.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_BIG.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_HUGE.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.ENERGY_OUTPUT_HATCH_ULTIMATE.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_TINY.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_SMALL.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_NORMAL.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_REINFORCED.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_BIG.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_HUGE.get(), (Block)BlockRegistration.ITEM_INPUT_BUS_LUDICROUS.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_TINY.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_SMALL.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_NORMAL.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_REINFORCED.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_BIG.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_HUGE.get(), (Block)BlockRegistration.ITEM_OUTPUT_BUS_LUDICROUS.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_TINY.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_SMALL.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_BIG.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_HUGE.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.FLUID_INPUT_HATCH_VACUUM.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_TINY.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_SMALL.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_BIG.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_HUGE.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.FLUID_OUTPUT_HATCH_VACUUM.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_TINY.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_SMALL.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_BIG.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_HUGE.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.EXPERIENCE_INPUT_HATCH_VACUUM.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_TINY.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_SMALL.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_NORMAL.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_REINFORCED.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_BIG.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_HUGE.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_LUDICROUS.get(), (Block)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_VACUUM.get(), (Block)BlockRegistration.DIMENSIONAL_DETECTOR.get(), (Block)BlockRegistration.BIOME_READER.get(), (Block)BlockRegistration.WEATHER_SENSOR.get(), (Block)BlockRegistration.TIME_COUNTER.get(), (Block)BlockRegistration.CHUNKLOADER.get(), (Block)BlockRegistration.HEIGHT_METER.get(), (Block)BlockRegistration.PARALLEL_HATCH_BASIC.get(), (Block)BlockRegistration.PARALLEL_HATCH_MEDIUM.get(), (Block)BlockRegistration.PARALLEL_HATCH_ADVANCED.get(), (Block)BlockRegistration.PARALLEL_HATCH_ULTIMATE.get(), (Block)BlockRegistration.PARALLEL_HATCH_MAX.get()});
        ModularMachineryReborn.MACHINES_BLOCK.values().forEach(block -> event.register(ModularMachineryRebornClient::blockColor, new Block[]{block}));
    }

    @SubscribeEvent
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(ModularMachineryRebornClient::itemColor, new ItemLike[]{(ItemLike)ItemRegistration.MODULARIUM.get(), (ItemLike)ItemRegistration.CONTROLLER.get(), (ItemLike)ItemRegistration.CASING_PLAIN.get(), (ItemLike)ItemRegistration.CASING_VENT.get(), (ItemLike)ItemRegistration.CASING_FIREBOX.get(), (ItemLike)ItemRegistration.CASING_GEARBOX.get(), (ItemLike)ItemRegistration.CASING_REINFORCED.get(), (ItemLike)ItemRegistration.CASING_CIRCUITRY.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.ENERGY_INPUT_HATCH_ULTIMATE.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.ENERGY_OUTPUT_HATCH_ULTIMATE.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_TINY.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_SMALL.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_NORMAL.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_REINFORCED.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_BIG.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_HUGE.get(), (ItemLike)ItemRegistration.ITEM_INPUT_BUS_LUDICROUS.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_TINY.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_SMALL.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_NORMAL.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_REINFORCED.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_BIG.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_HUGE.get(), (ItemLike)ItemRegistration.ITEM_OUTPUT_BUS_LUDICROUS.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.FLUID_INPUT_HATCH_VACUUM.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.FLUID_OUTPUT_HATCH_VACUUM.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.EXPERIENCE_INPUT_HATCH_VACUUM.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_TINY.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_SMALL.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_NORMAL.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_REINFORCED.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_BIG.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_HUGE.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_LUDICROUS.get(), (ItemLike)ItemRegistration.EXPERIENCE_OUTPUT_HATCH_VACUUM.get(), (ItemLike)ItemRegistration.DIMENSIONAL_DETECTOR.get(), (ItemLike)ItemRegistration.BIOME_READER.get(), (ItemLike)ItemRegistration.WEATHER_SENSOR.get(), (ItemLike)ItemRegistration.TIME_COUNTER.get(), (ItemLike)ItemRegistration.CHUNKLOADER.get(), (ItemLike)ItemRegistration.HEIGHT_METER.get(), (ItemLike)ItemRegistration.PARALLEL_HATCH_BASIC.get(), (ItemLike)ItemRegistration.PARALLEL_HATCH_MEDIUM.get(), (ItemLike)ItemRegistration.PARALLEL_HATCH_ADVANCED.get(), (ItemLike)ItemRegistration.PARALLEL_HATCH_ULTIMATE.get(), (ItemLike)ItemRegistration.PARALLEL_HATCH_MAX.get()});
        ModularMachineryReborn.MACHINES_BLOCK.values().forEach(block -> event.register(ModularMachineryRebornClient::itemColor, new ItemLike[]{block}));
    }

    public static int blockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (level == null || pos == null) {
            return 0;
        }
        switch (tintIndex) {
            case 1: {
                level.getBlockTint(pos, BiomeColors.WATER_COLOR_RESOLVER);
                break;
            }
            case 2: {
                level.getBlockTint(pos, BiomeColors.GRASS_COLOR_RESOLVER);
                break;
            }
            case 3: {
                level.getBlockTint(pos, BiomeColors.FOLIAGE_COLOR_RESOLVER);
                break;
            }
            case 4: {
                BlockEntity tile = level.getBlockEntity(pos);
                if (!(tile instanceof ColorableMachineEntity)) break;
                ColorableMachineEntity machineTile = (ColorableMachineEntity)tile;
                return machineTile.getMachineColor();
            }
        }
        return Config.machineColor;
    }

    public static int itemColor(ItemStack stack, int tintIndex) {
        Item item = stack.getItem();
        if (item instanceof ItemDynamicColor) {
            ItemDynamicColor colorableItem = (ItemDynamicColor)item;
            return colorableItem.getColorFromItemstack(stack, tintIndex);
        }
        return Config.machineColor;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("block/nope")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("default/controller")));
        for (String folder : (List)MMRConfig.get().modelFolders.get()) {
            Minecraft.getInstance().getResourceManager().listResources("models/" + folder, s -> s.getPath().endsWith(".json")).forEach((rl, resource) -> {
                ResourceLocation modelRL = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)rl.getPath().substring(7).replace(".json", ""));
                event.register(ModelResourceLocation.standalone((ResourceLocation)modelRL));
            });
        }
        for (Block block : blockModelsToRegister) {
            Item item = block.asItem();
        }
        for (Item item : itemModelsToRegister) {
            String name = item.getClass().getSimpleName().toLowerCase();
            if (item instanceof BlockItem) {
                name = ((BlockItem)item).getBlock().getClass().getSimpleName().toLowerCase();
            }
            event.register(new ModelResourceLocation(ModularMachineryReborn.rl(name), "inventory"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        if (Mods.isEMILoaded()) {
            new MMREmiClientIntegration(this.bus);
        } else if (Mods.isJEILoaded()) {
            new MMRJeiClientIntegration(this.bus);
        }
    }

    public void registerBlockModel(Block block) {
        blockModelsToRegister.add(block);
    }

    public void registerItemModel(Item item) {
        itemModelsToRegister.add(item);
    }

    @SubscribeEvent
    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ContainerRegistration.CONTROLLER.get(), ControllerScreen::new);
        event.register((MenuType)ContainerRegistration.ENERGY_HATCH.get(), EnergyHatchScreen::new);
        event.register((MenuType)ContainerRegistration.FLUID_HATCH.get(), FluidHatchScreen::new);
        event.register((MenuType)ContainerRegistration.ITEM_BUS.get(), ItemBusScreen::new);
        event.register((MenuType)ContainerRegistration.EXPERIENCE_HATCH.get(), ExperienceHatchScreen::new);
        event.register((MenuType)ContainerRegistration.PARALLEL_HATCH.get(), ParallelHatchScreen::new);
    }

    @NotNull
    public static MachineControllerEntity getClientSideMachineControllerEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof MachineControllerEntity) {
            MachineControllerEntity controller = (MachineControllerEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Controller container without clicking on a Controller block");
    }

    public static EnergyHatchEntity getClientSideEnergyHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof EnergyHatchEntity) {
            EnergyHatchEntity controller = (EnergyHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Energy Hatch container without clicking on a Energy Hatch block");
    }

    public static FluidTankEntity getClientSideFluidHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof FluidTankEntity) {
            FluidTankEntity controller = (FluidTankEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Fluid Hatch container without clicking on a Fluid Hatch block");
    }

    public static TileItemBus getClientSideItemBusEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof TileItemBus) {
            TileItemBus controller = (TileItemBus)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Item Bus container without clicking on a Item Bus block");
    }

    public static ExperienceHatchEntity getClientSideExperienceHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof ExperienceHatchEntity) {
            ExperienceHatchEntity controller = (ExperienceHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Experience Hatch container without clicking on a Experience Hatch block");
    }

    public static ParallelHatchEntity getClientSideParallelHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof ParallelHatchEntity) {
            ParallelHatchEntity controller = (ParallelHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Parallel Hatch container without clicking on a Parallel Hatch block");
    }

    static {
        blockModelsToRegister = Lists.newLinkedList();
        itemModelsToRegister = Lists.newLinkedList();
    }
}

