/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.codec;

import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import es.degrassi.mmreborn.api.codec.EnumCodec;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class EnumMapCodec<K extends Enum<K>, V>
extends NamedMapCodec<Map<K, V>> {
    private final Class<K> keyEnum;
    private final NamedCodec<K> keyCodec;
    private final NamedCodec<V> valueCodec;
    @Nullable
    private final V defaultValue;
    private final String name;

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, NamedCodec<V> valueCodec) {
        return EnumMapCodec.of(keyEnum, valueCodec, null, "EnumMap<" + keyEnum.getSimpleName() + ", " + valueCodec.name() + ">");
    }

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, NamedCodec<V> valueCodec, @Nullable V defaultValue) {
        return EnumMapCodec.of(keyEnum, valueCodec, defaultValue, "EnumMap<" + keyEnum.getSimpleName() + ", " + valueCodec.name() + ">");
    }

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, NamedCodec<V> valueCodec, String name) {
        return EnumMapCodec.of(keyEnum, valueCodec, null, name);
    }

    public static <K extends Enum<K>, V> EnumMapCodec<K, V> of(Class<K> keyEnum, NamedCodec<V> valueCodec, @Nullable V defaultValue, String name) {
        return new EnumMapCodec<K, V>(keyEnum, valueCodec, defaultValue, name);
    }

    private EnumMapCodec(Class<K> keyEnum, NamedCodec<V> valueCodec, @Nullable V defaultValue, String name) {
        this.keyEnum = keyEnum;
        this.keyCodec = EnumCodec.of(keyEnum);
        this.valueCodec = valueCodec;
        this.defaultValue = defaultValue;
        this.name = name;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Arrays.stream((Enum[])this.keyEnum.getEnumConstants()).map(k -> ops.createString(k.toString()));
    }

    @Override
    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        EnumMap map = Maps.newEnumMap(this.keyEnum);
        Object defaultValue = this.defaultValue;
        if (input.get("default") != null) {
            DataResult<V> defaultResult = this.valueCodec.read(ops, input.get("default"));
            if (defaultResult.result().isPresent()) {
                defaultValue = defaultResult.result().get();
            } else if (defaultResult.error().isPresent()) {
                MMRLogger.INSTANCE.warn("Couldn't parse value for key {} in MapLike {}, {}", (Object)"default", (Object)input.toString(), (Object)((DataResult.Error)defaultResult.error().get()).message());
            }
        }
        input.entries().forEach(entry -> {
            DataResult<K> keyResult = this.keyCodec.read(ops, entry.getFirst());
            if (keyResult.result().isPresent()) {
                Enum key = (Enum)keyResult.result().get();
                DataResult<V> valueResult = this.valueCodec.read(ops, entry.getSecond());
                if (valueResult.result().isPresent()) {
                    map.put(key, valueResult.result().get());
                } else if (valueResult.error().isPresent()) {
                    MMRLogger.INSTANCE.warn("Couldn't parse value for key {} in MapLike {}, {}", (Object)key.toString(), (Object)input.toString(), (Object)((DataResult.Error)valueResult.error().get()).message());
                }
            }
        });
        if (defaultValue != null) {
            for (Enum key : (Enum[])this.keyEnum.getEnumConstants()) {
                if (map.containsKey(key)) continue;
                map.put(key, defaultValue);
            }
        }
        return DataResult.success((Object)map);
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        input.forEach((key, value) -> prefix.add(this.keyCodec.encodeStart(ops, key), this.valueCodec.encodeStart(ops, value)));
        return prefix;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

