/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.WarehouseSnapshot;
import com.minecolonies.core.items.ItemResourceScroll;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ResourceScrollSaveWarehouseSnapshotMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"resource_scroll_save_warehouse_snapshot", ResourceScrollSaveWarehouseSnapshotMessage::new);
    private final BlockPos builderPos;
    @NotNull
    private final Map<String, Integer> snapshot;
    @NotNull
    private final String workOrderHash;

    public ResourceScrollSaveWarehouseSnapshotMessage(BlockPos builderPos) {
        this(builderPos, Map.of(), "");
    }

    public ResourceScrollSaveWarehouseSnapshotMessage(BlockPos builderPos, @NotNull Map<String, Integer> snapshot, @NotNull String workOrderHash) {
        super(TYPE);
        this.builderPos = builderPos;
        this.snapshot = snapshot;
        this.workOrderHash = workOrderHash;
    }

    protected ResourceScrollSaveWarehouseSnapshotMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.builderPos = buf.readBoolean() ? buf.readBlockPos() : null;
        this.snapshot = buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt);
        this.workOrderHash = buf.readUtf(Short.MAX_VALUE);
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.builderPos != null);
        if (this.builderPos != null) {
            buf.writeBlockPos(this.builderPos);
        }
        buf.writeMap(this.snapshot, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
        buf.writeUtf(this.workOrderHash);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        player.getInventory().items.stream().filter(stack -> stack.getItem() instanceof ItemResourceScroll).filter(stack -> Objects.equals(this.builderPos, BuildingId.readFromItemStack(stack).id())).forEach(stack -> new WarehouseSnapshot(this.snapshot, this.workOrderHash).writeToItemStack((ItemStack)stack));
    }
}

