/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.core.items.ItemAssistantHammer;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public class PlayerAssistantBuildRequestMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assistanthammerrequest", PlayerAssistantBuildRequestMessage::new);
    private int workorderID;
    private BlockPos interactPos;

    public PlayerAssistantBuildRequestMessage(IColony colony, int workorderID, BlockPos interactPos) {
        super(TYPE, colony);
        this.workorderID = workorderID;
        this.interactPos = interactPos;
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.workorderID);
        buf.writeBlockPos(this.interactPos);
    }

    protected PlayerAssistantBuildRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, TYPE);
        this.workorderID = buf.readInt();
        this.interactPos = buf.readBlockPos();
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return Action.PLACE_BLOCKS;
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        IServerWorkOrder workOrder = colony.getWorkManager().getWorkOrder(this.workorderID);
        if (workOrder == null) {
            player.sendSystemMessage((Component)Component.literal((String)("Could not find workorder with id: " + this.workorderID)));
            return;
        }
        Item item = player.getMainHandItem().getItem();
        if (item instanceof ItemAssistantHammer) {
            ItemAssistantHammer hammer = (ItemAssistantHammer)item;
            hammer.placeBlock((Player)player, colony, workOrder, this.interactPos);
        }
    }
}

