/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.items.ISupplyItem;
import com.minecolonies.api.items.component.SupplyData;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowSupplies;
import com.minecolonies.core.client.gui.WindowSupplyStory;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyCampDeployer
extends AbstractItemMinecolonies
implements ISupplyItem {
    public ItemSupplyCampDeployer(Item.Properties properties) {
        super("supplycampdeployer", properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        SupplyData currentComponent = SupplyData.readFromItemStack(ctx.getItemInHand());
        if (!currentComponent.hasRandomKey()) {
            currentComponent.withRandomKey(ctx.getClickedPos().asLong()).writeToItemStack(ctx.getItemInHand());
        }
        if (ctx.getLevel().isClientSide) {
            if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.getLevel())) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(ctx.getPlayer());
                return InteractionResult.FAIL;
            }
            this.placeSupplyCamp(ctx.getClickedPos().relative(ctx.getHorizontalDirection(), 10).above(), ctx.getPlayer().getDirection(), ctx.getItemInHand(), ctx.getHand());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        SupplyData currentComponent = SupplyData.readFromItemStack(stack);
        if (!currentComponent.hasRandomKey()) {
            currentComponent.withRandomKey(playerIn.blockPosition().asLong()).writeToItemStack(stack);
        }
        if (worldIn.isClientSide) {
            if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(playerIn);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyCamp(null, playerIn.getDirection(), stack, hand);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyCamp(@Nullable BlockPos pos, @NotNull Direction direction, ItemStack itemInHand, InteractionHand hand) {
        SupplyData currentComponent = SupplyData.readFromItemStack(itemInHand);
        if (!currentComponent.sawStory()) {
            new WindowSupplyStory(pos, "supplycamp", itemInHand, hand).open();
            return;
        }
        if (pos == null) {
            new WindowSupplies(pos, "supplycamp").open();
            return;
        }
        new WindowSupplies(pos, "supplycamp").open();
    }

    public static boolean canCampBePlaced(@NotNull Level world, @NotNull BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").getBlueprint();
        if (blueprint == null) {
            return false;
        }
        BlockPos zeroPos = pos.subtract((Vec3i)blueprint.getPrimaryBlockOffset());
        int sizeX = blueprint.getSizeX();
        int sizeZ = blueprint.getSizeZ();
        int groundHeight = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)blueprint, (int)1) - 1;
        int groundLevel = zeroPos.getY() + groundHeight;
        ArrayList<PlacementError> needsAirAbove = new ArrayList<PlacementError>();
        ArrayList<PlacementError> needsSolidBelow = new ArrayList<PlacementError>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int x = 0; x < sizeX; ++x) {
                BlockPos worldPos = new BlockPos(zeroPos.getX() + x, groundLevel, zeroPos.getZ() + z);
                if (blueprint.getBlockState(new BlockPos(x, groundHeight, z)).getBlock() != ModBlocks.blockSubstitution.get()) {
                    ItemSupplyCampDeployer.checkIfSolidAndNotInColony(world, worldPos, needsSolidBelow, placer);
                }
                if (!BlockUtils.isAnySolid((BlockState)world.getBlockState(worldPos.above()))) continue;
                needsAirAbove.add(new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, worldPos.above()));
            }
        }
        if ((double)needsAirAbove.size() > (double)(sizeX * sizeZ) * 0.3333333333333333 || (double)needsSolidBelow.size() > (double)(sizeX * sizeZ) * 0.3333333333333333) {
            placementErrorList.addAll(needsAirAbove);
            placementErrorList.addAll(needsSolidBelow);
            return false;
        }
        return true;
    }

    private static void checkIfSolidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        boolean isSolid = BlockUtils.isAnySolid((BlockState)world.getBlockState(pos));
        boolean notInAnyColony = ItemSupplyCampDeployer.hasPlacePermission(world, pos, placer);
        if (!isSolid) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_SOLID, pos));
        }
        if (!notInAnyColony) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos));
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

