/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.items.ModItems;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ItemPharaoScepter
extends BowItem {
    public ItemPharaoScepter(Item.Properties properties) {
        super(properties.durability(384));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)worldIn, (Player)playerIn, (InteractionHand)handIn, (boolean)true);
        if (ret != null) {
            return ret;
        }
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            float speed;
            Player playerentity = (Player)entityLiving;
            int useDuration = this.getUseDuration(stack, entityLiving) - timeLeft;
            if ((useDuration = EventHooks.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)playerentity, (int)useDuration, (boolean)true)) < 0) {
                return;
            }
            ItemStack itemstack = playerentity.getProjectile(stack);
            if (!itemstack.isEmpty() && !((double)(speed = ItemPharaoScepter.getPowerForTime((int)useDuration)) < 0.1)) {
                List list = ItemPharaoScepter.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)entityLiving);
                if (worldIn instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)worldIn;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, entityLiving, entityLiving.getUsedItemHand(), stack, list, speed * 3.0f, 1.0f, speed == 1.0f, null);
                    }
                }
                worldIn.playSound(null, playerentity.getX(), playerentity.getY(), playerentity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (entityLiving.getRandom().nextFloat() * 0.4f + 1.2f) + speed * 0.5f);
                playerentity.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return itemStack -> true;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        if (arrow.getOwner() == null) {
            return arrow;
        }
        AbstractArrow entity = ((ArrowItem)ModItems.firearrow).createArrow(arrow.level(), new ItemStack((ItemLike)ModItems.firearrow, 1), (LivingEntity)arrow.getOwner(), weaponStack);
        entity.pickup = AbstractArrow.Pickup.DISALLOWED;
        entity.setRemainingFireTicks(60);
        return entity;
    }
}

