/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.generation.CustomRecipeProvider;
import com.minecolonies.core.generation.defaults.workers.DefaultRecipeLootProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultCrusherCraftingProvider
extends CustomRecipeProvider {
    private static final String CRUSHER = ModJobs.CRUSHER_ID.getPath();

    public DefaultCrusherCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultCrusherCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        Rule noGildedHammer = builder -> builder.maxResearchId(ResearchConstants.CRUSHING_11);
        Rule withGildedHammer = builder -> builder.minResearchId(ResearchConstants.CRUSHING_11);
        Rule withTheDepths = builder -> builder.minResearchId(ResearchConstants.THE_DEPTHS);
        Rule gravelLoot = builder -> builder.lootTable(DefaultRecipeLootProvider.LOOT_TABLE_GRAVEL);
        this.crush(consumer, "bonemeal1", new ItemStack((ItemLike)Items.BONE), new ItemStack((ItemLike)Items.BONE_MEAL, 3), noGildedHammer);
        this.crush(consumer, "bonemeal2", new ItemStack((ItemLike)Items.BONE), new ItemStack((ItemLike)Items.BONE_MEAL, 5), withGildedHammer);
        this.crush(consumer, "bonemeal3", new ItemStack((ItemLike)Items.BONE_BLOCK), new ItemStack((ItemLike)Items.BONE_MEAL, 9), new Rule[0]);
        this.crush(consumer, "gravel1", new ItemStack((ItemLike)Items.COBBLESTONE, 2), new ItemStack((ItemLike)Items.GRAVEL), noGildedHammer, gravelLoot);
        this.crush(consumer, "gravel2", new ItemStack((ItemLike)Items.COBBLESTONE), new ItemStack((ItemLike)Items.GRAVEL), withGildedHammer, gravelLoot);
        this.crush(consumer, "sand1", new ItemStack((ItemLike)Items.GRAVEL, 2), new ItemStack((ItemLike)Items.SAND), noGildedHammer);
        this.crush(consumer, "sand2", new ItemStack((ItemLike)Items.GRAVEL), new ItemStack((ItemLike)Items.SAND), withGildedHammer);
        this.crush(consumer, "clay1", new ItemStack((ItemLike)Items.SAND, 2), new ItemStack((ItemLike)Items.CLAY), noGildedHammer);
        this.crush(consumer, "clay2", new ItemStack((ItemLike)Items.SAND), new ItemStack((ItemLike)Items.CLAY), withGildedHammer);
        this.crush(consumer, "clay_ball", new ItemStack((ItemLike)Items.CLAY), new ItemStack((ItemLike)Items.CLAY_BALL, 4), new Rule[0]);
        this.crush(consumer, "cobble", new ItemStack((ItemLike)Items.TUFF, 2), new ItemStack((ItemLike)Items.COBBLESTONE), withTheDepths, noGildedHammer);
        this.crush(consumer, "cobble2", new ItemStack((ItemLike)Items.TUFF), new ItemStack((ItemLike)Items.COBBLESTONE), withTheDepths, withGildedHammer);
        this.crush(consumer, "tuff", new ItemStack((ItemLike)Items.COBBLED_DEEPSLATE, 2), new ItemStack((ItemLike)Items.TUFF), withTheDepths, noGildedHammer);
        this.crush(consumer, "tuff2", new ItemStack((ItemLike)Items.COBBLED_DEEPSLATE), new ItemStack((ItemLike)Items.TUFF), withTheDepths, withGildedHammer);
    }

    private void crush(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, @NotNull String name, @NotNull ItemStack input, @NotNull ItemStack output, Rule ... rules) {
        CustomRecipeProvider.CustomRecipeBuilder builder = this.recipe(CRUSHER, "custom", name).inputs(List.of(new ItemStorage(input))).result(output);
        for (Rule rule : rules) {
            rule.accept(builder);
        }
        builder.build(consumer);
    }

    private static interface Rule
    extends Consumer<CustomRecipeProvider.CustomRecipeBuilder> {
    }
}

