/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.types.ExtraBlockType;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.constant.TagConstants;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultItemTagsProvider
extends ItemTagsProvider {
    private final PackOutput.PathProvider langPath;
    private JsonObject langJson;

    public DefaultItemTagsProvider(@NotNull PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @NotNull BlockTagsProvider blockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagsProvider.contentsGetter(), "minecolonies", existingFileHelper);
        this.langPath = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput output) {
        this.langJson = new JsonObject();
        return super.run(output).thenCompose(r -> DataProvider.saveStable((CachedOutput)output, (JsonElement)this.langJson, (Path)this.langPath.json(new ResourceLocation("minecolonies", "tag.item"))));
    }

    @Deprecated
    @NotNull
    protected IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(@NotNull TagKey<Item> tagKey) {
        return super.tag(tagKey);
    }

    @NotNull
    protected IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(@NotNull TagKey<Item> tagKey, @NotNull String description) {
        this.translate(tagKey, description);
        return super.tag(tagKey);
    }

    @Deprecated
    protected void copy(@NotNull TagKey<Block> blockTag, @NotNull TagKey<Item> itemTag) {
        super.copy(blockTag, itemTag);
    }

    protected void copy(@NotNull TagKey<Block> blockTag, @NotNull TagKey<Item> itemTag, @NotNull String description) {
        this.translate(itemTag, description);
        super.copy(blockTag, itemTag);
    }

    private void translate(@NotNull TagKey<Item> tagKey, @NotNull String description) {
        String translationKey = Tags.getTagTranslationKey(tagKey);
        if (!this.langJson.has(translationKey)) {
            this.langJson.addProperty(translationKey, description);
        }
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        ModTags.init();
        this.tag(ModTags.compostables_poor, "Poor-Quality Compostables").addTags(new TagKey[]{Tags.Items.SEEDS, ItemTags.SAPLINGS}).add((Object[])new Item[]{Items.PITCHER_POD, Items.SMALL_DRIPLEAF});
        this.tag(ModTags.compostables, "Normal-Quality Compostables").add((Object)Items.ROTTEN_FLESH).add((Object[])new Item[]{Items.FEATHER, Items.PUMPKIN, Items.CARVED_PUMPKIN}).add((Object[])new Item[]{Items.SHORT_GRASS, Items.TALL_GRASS, Items.FERN, Items.LARGE_FERN, Items.HAY_BLOCK}).add((Object[])new Item[]{Items.BIG_DRIPLEAF, Items.SPORE_BLOSSOM, Items.GLOW_LICHEN, ModItems.mistletoe}).add((Object[])new Item[]{Items.KELP, Items.DRIED_KELP_BLOCK, Items.SEAGRASS, Items.CACTUS, Items.SUGAR_CANE, Items.VINE, Items.TWISTING_VINES, Items.WEEPING_VINES}).add((Object[])new Item[]{Items.COCOA_BEANS, Items.LILY_PAD, Items.SEA_PICKLE}).add((Object[])new Item[]{Items.BROWN_MUSHROOM_BLOCK, Items.RED_MUSHROOM_BLOCK, Items.MUSHROOM_STEM}).add((Object[])new Item[]{Items.CAKE, Items.MELON, Items.RABBIT_FOOT, Items.FERMENTED_SPIDER_EYE}).add((Object[])new Item[]{Items.MOSS_BLOCK, Items.MOSS_CARPET, Items.SHROOMLIGHT}).add((Object[])new Item[]{Items.NETHER_WART_BLOCK, Items.WARPED_WART_BLOCK, Items.NETHER_SPROUTS, Items.MANGROVE_ROOTS, Items.HANGING_ROOTS, Items.CRIMSON_ROOTS, Items.WARPED_ROOTS}).addTags(new TagKey[]{Tags.Items.CROPS, Tags.Items.EGGS, ItemTags.FLOWERS, ItemTags.FISHES, ItemTags.LEAVES, ItemTags.WOOL}).addTags(new TagKey[]{Tags.Items.FOODS_RAW_FISH, Tags.Items.FOODS_RAW_MEAT, Tags.Items.MUSHROOMS, ModTags.fungi});
        this.tag(ModTags.compostables_rich, "Rich-Quality Compostables").add((Object[])new Item[]{Items.PODZOL, ModBlocks.blockCompostedDirt.asItem()});
        this.copy(ModTags.concreteBlocks, ModTags.concreteItems, "Concrete");
        this.tag(ModTags.concretePowderItems, "Concrete Powder").addTag(Tags.Items.CONCRETE_POWDERS);
        this.tag(ModTags.rawMeat, "Raw Meat").addTag(Tags.Items.FOODS_RAW_MEAT);
        TagKey shulkerBoxes = ItemTags.create((ResourceLocation)new ResourceLocation("minecolonies", "shulker_boxes"));
        this.tag((TagKey<Item>)shulkerBoxes, "Shulker Boxes").addTag(Tags.Items.SHULKER_BOXES);
        TagKey glazedTerracotta = ItemTags.create((ResourceLocation)new ResourceLocation("minecolonies", "glazed_terracotta"));
        this.tag((TagKey<Item>)glazedTerracotta, "Glazed Terracotta").addTag(Tags.Items.GLAZED_TERRACOTTAS);
        TagKey storageBlocks = ItemTags.create((ResourceLocation)new ResourceLocation("minecolonies", "storage_blocks"));
        this.tag((TagKey<Item>)storageBlocks, "Storage Blocks").addTag(Tags.Items.STORAGE_BLOCKS).add((Object)Items.BONE_BLOCK).add((Object)Items.HAY_BLOCK).add((Object)Items.DRIED_KELP_BLOCK).add((Object)Items.HONEY_BLOCK).add((Object)Items.HONEYCOMB_BLOCK).add((Object)Items.SNOW_BLOCK).add((Object)Items.COPPER_BLOCK).add((Object)Items.RAW_COPPER_BLOCK).add((Object)Items.RAW_GOLD_BLOCK).add((Object)Items.RAW_IRON_BLOCK);
        this.tag(ModTags.floristFlowers, "Florist Flowers").add((Object)Items.SUNFLOWER).add((Object)Items.LILAC).add((Object)Items.ROSE_BUSH).add((Object)Items.PEONY).add((Object)Items.TALL_GRASS).add((Object)Items.LARGE_FERN).add((Object)Items.FERN).add((Object)Items.DANDELION).add((Object)Items.POPPY).add((Object)Items.BLUE_ORCHID).add((Object)Items.ALLIUM).add((Object)Items.AZURE_BLUET).add((Object)Items.RED_TULIP).add((Object)Items.ORANGE_TULIP).add((Object)Items.WHITE_TULIP).add((Object)Items.PINK_TULIP).add((Object)Items.OXEYE_DAISY).add((Object)Items.CORNFLOWER).add((Object)Items.LILY_OF_THE_VALLEY);
        this.copy(ModTags.fungiBlocks, ModTags.fungi, "Fungi");
        this.tag(ModTags.meshes, "Meshes").add((Object)ModItems.sifterMeshString).add((Object)ModItems.sifterMeshFlint).add((Object)ModItems.sifterMeshIron).add((Object)ModItems.sifterMeshDiamond);
        this.tag(ModTags.excludedFood, "Excluded Food").add((Object)Items.ENCHANTED_GOLDEN_APPLE).add((Object)Items.POISONOUS_POTATO).add((Object)Items.ROTTEN_FLESH).add((Object)Items.SPIDER_EYE).add((Object)Items.TROPICAL_FISH).add((Object)Items.PUFFERFISH).add((Object)Items.SUSPICIOUS_STEW).add((Object)ModItems.chorusBread).add((Object)ModItems.goldenBread);
        this.tag(ModTags.breakable_ore, "Breakable Ore").addTag(ItemTags.COAL_ORES).addTag(ItemTags.IRON_ORES).addTag(ItemTags.COPPER_ORES).addTag(ItemTags.GOLD_ORES).addTag(ItemTags.REDSTONE_ORES).addTag(ItemTags.EMERALD_ORES).addTag(ItemTags.LAPIS_ORES).addTag(ItemTags.DIAMOND_ORES).add((Object)Items.NETHER_QUARTZ_ORE);
        this.tag(ModTags.raw_ore, "Raw Ore").add((Object)Items.RAW_IRON).add((Object)Items.RAW_COPPER).add((Object)Items.RAW_GOLD);
        this.tag(ModTags.poisonous_food, "Poisonous Food").add((Object)Items.POISONOUS_POTATO).add((Object)Items.CHICKEN).add((Object)Items.SPIDER_EYE).add((Object)Items.ROTTEN_FLESH);
        Object[] paperExtras = DefaultItemTagsProvider.getDomumExtra(ExtraBlockType.BASE_PAPER, ExtraBlockType.LIGHT_PAPER);
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_BAKER), "Baker Crafting Ingredients").addTag(Tags.Items.CROPS_WHEAT);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_BAKER), "Baker Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_BAKER), "Baker Crafting Products").add((Object)ModItems.cornmeal).add((Object)ModItems.cheese_pizza).add((Object)ModItems.plain_cheesecake).add((Object)ModItems.apple_pie);
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_BAKER), "Baker Crafting Excluded Products").add((Object[])new Item[]{Items.BREAD, Items.CAKE, Items.COOKIE, Items.PUMPKIN_PIE}).add((Object)Items.PACKED_MUD).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_COOK));
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_BLACKSMITH), "Blacksmith Crafting Ingredients").add((Object[])new Item[]{Items.DIAMOND_BLOCK, Items.EMERALD_BLOCK}).addTags(new TagKey[]{Tags.Items.NUGGETS, Tags.Items.INGOTS});
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_BLACKSMITH), "Blacksmith Crafting Excluded Ingredients").addTag(Tags.Items.CROPS).addTag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_DYER)).addTag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_MECHANIC)).add((Object[])new Item[]{Items.BRICK, Items.NETHER_BRICK});
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_BLACKSMITH), "Blacksmith Crafting Products").add((Object[])new Item[]{Items.SHEARS, Items.LIGHTNING_ROD, Items.MACE}).addTags(new TagKey[]{Tags.Items.NUGGETS, Tags.Items.INGOTS});
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_BLACKSMITH), "Blacksmith Crafting Excluded Products").addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_DYER)).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_MECHANIC)).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_SAWMILL)).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_STONEMASON)).add((Object)Items.FIREWORK_STAR).add((Object)Items.GLISTERING_MELON_SLICE).add((Object[])new Item[]{Items.BOW, Items.CROSSBOW});
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_COOK), "Chef Crafting Ingredients").addTag(ItemTags.FISHES).add((Object)Items.BEEF).add((Object)Items.MUTTON).add((Object)Items.CHICKEN).add((Object)Items.PORKCHOP).add((Object)Items.RABBIT).add((Object)Items.POTATO).add((Object)Items.KELP).add((Object)Items.DRIED_KELP).add((Object)Items.DRIED_KELP_BLOCK).add((Object)Items.EGG).add((Object)ModItems.large_milk_bottle).add((Object)ModItems.large_soy_milk_bottle).add((Object)ModItems.large_water_bottle).add((Object)Items.MILK_BUCKET);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_COOK), "Chef Crafting Excluded Ingredients").addTag(Tags.Items.CROPS_WHEAT);
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_COOK), "Chef Crafting Products").add((Object)ModItems.baked_salmon).add((Object)ModItems.butter).add((Object)ModItems.cabochis).add((Object)ModItems.cheddar_cheese).add((Object)ModItems.congee).add((Object)ModItems.cooked_rice).add((Object)ModItems.eggplant_dolma).add((Object)ModItems.feta_cheese).add((Object)ModItems.lamb_stew).add((Object)ModItems.pasta_plain).add((Object)ModItems.pasta_tomato).add((Object)ModItems.pepper_hummus).add((Object)ModItems.pottage).add((Object)ModItems.raw_noodle).add((Object)ModItems.rice_ball).add((Object)ModItems.tofu).add((Object)ModItems.creamcheese).add((Object)ModItems.soysauce).add((Object)ModItems.cheese_ravioli).add((Object)ModItems.chicken_broth).add((Object)ModItems.corn_chowder).add((Object)ModItems.spicy_grilled_chicken).add((Object)ModItems.kebab).add((Object)ModItems.meat_ravioli).add((Object)ModItems.mint_jelly).add((Object)ModItems.mint_tea).add((Object)ModItems.pea_soup).add((Object)ModItems.polenta).add((Object)ModItems.potato_soup).add((Object)ModItems.squash_soup).add((Object)ModItems.veggie_ravioli).add((Object)ModItems.yogurt).add((Object)ModItems.baked_salmon).add((Object)ModItems.eggdrop_soup).add((Object)ModItems.fish_n_chips).add((Object)ModItems.kimchi).add((Object)ModItems.pierogi).add((Object)ModItems.veggie_quiche).add((Object)ModItems.veggie_soup).add((Object)ModItems.yogurt_with_berries).add((Object)ModItems.mutton_dinner).add((Object)ModItems.tortillas).add((Object)ModItems.spicy_eggplant);
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_COOK), "Chef Crafting Excluded Products").add((Object[])new Item[]{Items.BREAD, Items.CAKE, Items.COOKIE, Items.PUMPKIN_PIE, ModItems.cheese_pizza, ModItems.plain_cheesecake, ModItems.apple_pie, ModItems.cornmeal});
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_DYER), "Dyer Crafting Ingredients").addTag(Tags.Items.DYES);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_DYER), "Dyer Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_DYER), "Dyer Crafting Products").addTag(Tags.Items.DYES).add((Object)Items.FIREWORK_STAR).add((Object)Items.RED_NETHER_BRICKS);
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_DYER), "Dyer Crafting Excluded Products").addTags(new TagKey[]{ModTags.concretePowderItems});
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_DYER_SMELTING), "Dyer Smelting Products").addTag(Tags.Items.DYES);
        com.ldtteam.domumornamentum.block.ModBlocks.getInstance().getExtraTopBlocks().stream().filter(f -> f.getType().getColor() != null).map(Block::asItem).forEach(item -> super.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_DYER)).add(item));
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_FARMER), "Farmer Crafting Ingredients").add((Object)Items.HAY_BLOCK).add((Object)Items.SHORT_GRASS).add((Object)Items.FERN);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_FARMER), "Farmer Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_FARMER), "Farmer Crafting Products").add((Object)Items.HAY_BLOCK).addTag(Tags.Items.SEEDS).add((Object)ModBlocks.blockCompostedDirt.asItem()).add((Object)Items.MELON).add((Object)Items.COARSE_DIRT).add((Object)Items.FERMENTED_SPIDER_EYE).add((Object)Items.GLISTERING_MELON_SLICE).add((Object[])new Item[]{Items.MUD_BRICKS, Items.PACKED_MUD, Items.MUDDY_MANGROVE_ROOTS});
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_FARMER), "Farmer Crafting Excluded Products");
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_FLETCHER), "Fletcher Crafting Ingredients").addTag(Tags.Items.STRINGS).addTag(ItemTags.LEAVES).addTag(ItemTags.WOOL).add((Object)Items.RABBIT_HIDE).add((Object)Items.LEATHER).add((Object)Items.FISHING_ROD);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_FLETCHER), "Fletcher Crafting Excluded Ingredients").addTag(Tags.Items.DYES);
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_FLETCHER), "Fletcher Crafting Products").addTag(Tags.Items.STRINGS).add((Object)Items.MOSS_CARPET);
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_FLETCHER), "Fletcher Crafting Excluded Products").add((Object)Items.BOOK).add((Object)Items.ITEM_FRAME);
        this.tag(ModTags.crafterDoIngredient.get(TagConstants.CRAFTING_FLETCHER), "Fletcher Domum Ingredients").add((Object[])new Item[]{Items.AZALEA_LEAVES, Items.FLOWERING_AZALEA_LEAVES}).add((Object[])new Item[]{Items.COARSE_DIRT, Items.ROOTED_DIRT, Items.GRASS_BLOCK, Items.HAY_BLOCK, Items.MOSS_BLOCK, Items.DRIED_KELP_BLOCK}).add((Object[])new Item[]{Items.MUD, Items.PACKED_MUD, Items.MUD_BRICKS, Items.MUDDY_MANGROVE_ROOTS, Items.PODZOL, Items.MYCELIUM}).add((Object[])new Item[]{Items.BROWN_MUSHROOM_BLOCK, Items.RED_MUSHROOM_BLOCK, Items.NETHER_WART_BLOCK, Items.WARPED_WART_BLOCK});
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_GLASSBLOWER), "Glassblower Crafting Ingredients").addTag(Tags.Items.GLASS_BLOCKS).addTag(Tags.Items.GLASS_PANES);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_GLASSBLOWER), "Glassblower Crafting Excluded Ingredients").addTag(Tags.Items.DYES);
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_GLASSBLOWER), "Glassblower Crafting Products");
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_GLASSBLOWER), "Glassblower Crafting Excluded Products");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_GLASSBLOWER_SMELTING), "Glassblower Smelting Products").addTag(Tags.Items.GLASS_BLOCKS);
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_MECHANIC), "Mechanic Crafting Ingredients").addTag(Tags.Items.DUSTS_REDSTONE).addTag(Tags.Items.ORES_REDSTONE).addTag(Tags.Items.STORAGE_BLOCKS_REDSTONE).addTag(storageBlocks).add((Object)Items.BLAZE_ROD).add((Object)Items.SLIME_BALL).add((Object)Items.GUNPOWDER).add((Object)Items.ENDER_PEARL).add((Object)Items.ENDER_EYE).add((Object)Items.REDSTONE_TORCH).add((Object)Items.GLOWSTONE_DUST).add((Object)Items.DRIED_KELP_BLOCK).add((Object)Items.AMETHYST_SHARD);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_MECHANIC), "Mechanic Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_MECHANIC), "Mechanic Crafting Products").addTag(storageBlocks).addTag(ItemTags.RAILS).addTag(ItemTags.BUTTONS).addTag(ItemTags.WOODEN_PRESSURE_PLATES).add((Object)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).add((Object)Items.LIGHT_WEIGHTED_PRESSURE_PLATE).add((Object)Items.POLISHED_BLACKSTONE_PRESSURE_PLATE).add((Object)Items.STONE_PRESSURE_PLATE).add((Object)Items.BLUE_ICE).add((Object)Items.PACKED_ICE).add((Object)Items.NETHER_WART_BLOCK).add((Object)Items.DAYLIGHT_DETECTOR).add((Object)Items.COMPARATOR).add((Object)Items.LEVER).add((Object)Items.PISTON).add((Object)Items.STICKY_PISTON).add((Object)Items.TRIPWIRE_HOOK).add((Object)Items.ENCHANTING_TABLE).add((Object)Items.JACK_O_LANTERN).add((Object)Items.LANTERN).add((Object)Items.SEA_LANTERN).add((Object)Items.SOUL_LANTERN).add((Object)Items.SOUL_TORCH).add((Object)Items.END_ROD).add((Object)Items.TORCH).add((Object)Items.ENDER_CHEST).add((Object)Items.TRAPPED_CHEST).add((Object)Items.FIRE_CHARGE).add((Object)Items.CONDUIT).add((Object)Items.RESPAWN_ANCHOR).add((Object)Items.RECOVERY_COMPASS).add((Object)Items.SHULKER_BOX).add((Object)Items.SLIME_BALL).add((Object)Items.GLOW_ITEM_FRAME).add((Object)Items.SPYGLASS).add((Object[])new Item[]{Items.WAXED_COPPER_DOOR, Items.WAXED_COPPER_TRAPDOOR}).add((Object[])new Item[]{Items.WAXED_EXPOSED_COPPER_DOOR, Items.WAXED_EXPOSED_COPPER_TRAPDOOR}).add((Object[])new Item[]{Items.WAXED_OXIDIZED_COPPER_DOOR, Items.WAXED_OXIDIZED_COPPER_TRAPDOOR}).add((Object[])new Item[]{Items.WAXED_WEATHERED_COPPER_DOOR, Items.WAXED_WEATHERED_COPPER_TRAPDOOR});
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_MECHANIC), "Mechanic Crafting Excluded Products").add((Object)Items.SPECTRAL_ARROW).add((Object[])new Item[]{Items.HAY_BLOCK, Items.WHEAT}).add((Object)Items.LEAD);
        this.tag(ModTags.crafterIngredient.get("plantation"), "Plantation Crafting Ingredients").add((Object)Items.BAMBOO).add(paperExtras);
        this.tag(ModTags.crafterIngredientExclusions.get("plantation"), "Plantation Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get("plantation"), "Plantation Crafting Products").add((Object)Items.BOOK).add((Object)Items.PAPER).add((Object)Items.SUGAR).add((Object)Items.WRITABLE_BOOK).add(paperExtras);
        this.tag(ModTags.crafterProductExclusions.get("plantation"), "Plantation Crafting Excluded Products");
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_SAWMILL), "Sawmill Crafting Ingredients").addTag(ItemTags.LOGS).add((Object)Items.CACTUS);
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_SAWMILL), "Sawmill Crafting Excluded Ingredients").addTag(Tags.Items.INGOTS).addTag(Tags.Items.STONES).addTag(Tags.Items.DUSTS_REDSTONE).addTag(Tags.Items.STRINGS);
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_SAWMILL), "Sawmill Crafting Products").addTag(ItemTags.PLANKS).addTags(new TagKey[]{ItemTags.WOODEN_SLABS, ItemTags.WOODEN_STAIRS}).add((Object[])new Item[]{Items.BAMBOO_MOSAIC, Items.BAMBOO_MOSAIC_SLAB, Items.BAMBOO_MOSAIC_STAIRS, Items.BAMBOO_HANGING_SIGN}).addTags(new TagKey[]{ItemTags.BOATS, ItemTags.CHEST_BOATS}).add((Object)ModBlocks.blockBarrel.asItem());
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_SAWMILL), "Sawmill Crafting Excluded Products").addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_MECHANIC)).add((Object)Items.MAGMA_CREAM);
        this.tag(ModTags.crafterDoIngredient.get(TagConstants.CRAFTING_SAWMILL), "Sawmill Crafting Domum Ingredients").add((Object[])new Item[]{Items.BAMBOO_BLOCK, Items.BAMBOO_MOSAIC, Items.BAMBOO_PLANKS, Items.STRIPPED_BAMBOO_BLOCK}).add((Object[])new Item[]{Items.CRIMSON_NYLIUM, Items.WARPED_NYLIUM});
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_STONEMASON), "Stonemason Crafting Ingredients").add((Object[])new Item[]{Items.BRICK, Items.BRICKS, Items.STONE_BRICKS, Items.CHISELED_STONE_BRICKS, Items.CRACKED_STONE_BRICKS, Items.MOSSY_STONE_BRICKS}).add((Object[])new Item[]{Items.NETHER_BRICK, Items.NETHERRACK, Items.NETHER_BRICKS, Items.CHISELED_NETHER_BRICKS, Items.RED_NETHER_BRICKS}).add((Object[])new Item[]{Items.DEEPSLATE_BRICKS, Items.DEEPSLATE_TILES, Items.CRACKED_DEEPSLATE_BRICKS, Items.CRACKED_DEEPSLATE_TILES}).add((Object)Items.POPPED_CHORUS_FRUIT).add((Object[])new Item[]{Items.PURPUR_BLOCK, Items.PURPUR_SLAB, Items.PURPUR_PILLAR}).add((Object[])new Item[]{Items.PRISMARINE_SHARD, Items.PRISMARINE_CRYSTALS}).add((Object[])new Item[]{Items.SMOOTH_STONE, Items.OBSIDIAN, Items.CRYING_OBSIDIAN}).add((Object[])new Item[]{Items.DEEPSLATE, Items.CHISELED_DEEPSLATE, Items.COBBLED_DEEPSLATE, Items.POLISHED_DEEPSLATE}).add((Object[])new Item[]{Items.BLACKSTONE, Items.GILDED_BLACKSTONE}).add((Object[])new Item[]{Items.POLISHED_BLACKSTONE, Items.POLISHED_BLACKSTONE_BRICKS}).add((Object[])new Item[]{Items.EXPOSED_COPPER, Items.OXIDIZED_COPPER, Items.WEATHERED_COPPER}).add((Object[])new Item[]{Items.WAXED_COPPER_BLOCK, Items.WAXED_EXPOSED_COPPER, Items.WAXED_OXIDIZED_COPPER, Items.WAXED_WEATHERED_COPPER}).add((Object[])new Item[]{Items.CUT_COPPER, Items.EXPOSED_CUT_COPPER, Items.OXIDIZED_CUT_COPPER, Items.WEATHERED_CUT_COPPER}).add((Object[])new Item[]{Items.WAXED_CUT_COPPER, Items.WAXED_EXPOSED_CUT_COPPER, Items.WAXED_OXIDIZED_CUT_COPPER, Items.WAXED_WEATHERED_CUT_COPPER}).add((Object[])new Item[]{Items.BASALT, Items.POLISHED_BASALT, Items.SMOOTH_BASALT, Items.TUFF}).addTags(new TagKey[]{ItemTags.TERRACOTTA, glazedTerracotta}).addTags(new TagKey[]{Tags.Items.STONES, Tags.Items.COBBLESTONES, Tags.Items.END_STONES}).addTags(new TagKey[]{Tags.Items.SANDSTONE_BLOCKS, ModTags.concreteItems}).addTags(new TagKey[]{com.ldtteam.domumornamentum.tag.ModTags.BRICK_ITEMS}).addTags(new TagKey[]{com.ldtteam.domumornamentum.tag.ModTags.EXTRA_BLOCK_ITEMS}).addTags(new TagKey[]{ItemTags.STAIRS, ItemTags.SLABS, ItemTags.WALLS});
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_STONEMASON), "Stonemason Crafting Excluded Ingredients").add((Object)Items.STICK).addTags(new TagKey[]{ItemTags.LOGS, ItemTags.PLANKS}).addTag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_MECHANIC)).addTag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_DYER));
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_STONEMASON), "Stonemason Crafting Products").add((Object[])new Item[]{Items.POLISHED_DEEPSLATE, Items.DEEPSLATE_BRICKS, Items.DEEPSLATE_TILES}).add((Object[])new Item[]{Items.CRACKED_DEEPSLATE_BRICKS, Items.CRACKED_DEEPSLATE_TILES}).add((Object[])new Item[]{Items.BRICKS, Items.POLISHED_BLACKSTONE_BRICKS, Items.TUFF_BRICKS}).add((Object[])new Item[]{Items.NETHER_BRICKS, Items.CHISELED_NETHER_BRICKS}).add((Object)Items.DRIPSTONE_BLOCK).add((Object[])new Item[]{Items.QUARTZ_BLOCK, Items.CHISELED_QUARTZ_BLOCK}).add((Object)Items.QUARTZ_PILLAR).add((Object)Items.QUARTZ_BRICKS).add((Object[])new Item[]{Items.CUT_COPPER, Items.EXPOSED_CUT_COPPER, Items.OXIDIZED_CUT_COPPER, Items.WEATHERED_CUT_COPPER}).add((Object[])new Item[]{Items.WAXED_COPPER_BLOCK, Items.WAXED_EXPOSED_COPPER, Items.WAXED_OXIDIZED_COPPER, Items.WAXED_WEATHERED_COPPER}).add((Object[])new Item[]{Items.WAXED_CUT_COPPER, Items.WAXED_EXPOSED_CUT_COPPER, Items.WAXED_OXIDIZED_CUT_COPPER, Items.WAXED_WEATHERED_CUT_COPPER}).add((Object)Items.MAGMA_BLOCK).add((Object)Items.SNOW).addTag(com.ldtteam.domumornamentum.tag.ModTags.BRICK_ITEMS).addTag(com.ldtteam.domumornamentum.tag.ModTags.EXTRA_BLOCK_ITEMS).addTags(new TagKey[]{Tags.Items.STONES, Tags.Items.COBBLESTONES, Tags.Items.SANDSTONE_BLOCKS}).addTags(new TagKey[]{ItemTags.STONE_BRICKS, ItemTags.SLABS, ItemTags.STAIRS, ItemTags.WALLS});
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_STONEMASON), "Stonemason Crafting Excluded Products").addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_MECHANIC)).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_DYER)).addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_SAWMILL)).addTag(ItemTags.TRIM_TEMPLATES).add((Object[])new Item[]{Items.LECTERN, Items.PISTON, Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}).add((Object[])new Item[]{Items.PRISMARINE, Items.PRISMARINE_BRICKS}).add(paperExtras);
        this.tag(ModTags.crafterDoIngredient.get(TagConstants.CRAFTING_STONEMASON), "Stonemason Crafting Domum Ingredients").add((Object[])new Item[]{Items.STONE, Items.CALCITE, Items.POLISHED_ANDESITE, Items.POLISHED_DIORITE, Items.POLISHED_GRANITE}).add((Object[])new Item[]{Items.QUARTZ_BLOCK, Items.SMOOTH_QUARTZ, Items.QUARTZ_BRICKS, Items.QUARTZ_PILLAR, Items.CHISELED_QUARTZ_BLOCK}).add((Object)Items.NETHERRACK).add((Object[])new Item[]{Items.BLACKSTONE, Items.CHISELED_POLISHED_BLACKSTONE, Items.CRACKED_POLISHED_BLACKSTONE_BRICKS}).add((Object[])new Item[]{Items.PRISMARINE, Items.PRISMARINE_BRICKS, Items.DARK_PRISMARINE}).add((Object)Items.END_STONE_BRICKS);
        this.tag(ModTags.crafterIngredient.get(TagConstants.CRAFTING_STONE_SMELTERY), "Stonesmelter Crafting Ingredients").addTag(ModTags.crafterProduct.get(TagConstants.CRAFTING_STONEMASON));
        this.tag(ModTags.crafterIngredientExclusions.get(TagConstants.CRAFTING_STONE_SMELTERY), "Stonesmelter Crafting Excluded Ingredients");
        this.tag(ModTags.crafterProduct.get(TagConstants.CRAFTING_STONE_SMELTERY), "Stonesmelter Crafting Products").add((Object)Items.BRICK).add((Object)Items.SMOOTH_BASALT).add((Object)Items.SMOOTH_QUARTZ).add((Object)Items.POPPED_CHORUS_FRUIT).add((Object)Items.SPONGE).add((Object)Items.SMOOTH_SANDSTONE).add((Object)Items.SMOOTH_RED_SANDSTONE).add((Object)Items.COAL).add((Object)Items.CHARCOAL).add((Object)Items.NETHER_BRICK).addTag(Tags.Items.STONES).add((Object)Items.SMOOTH_STONE).add((Object)Items.DEEPSLATE).addTags(new TagKey[]{ItemTags.TERRACOTTA, glazedTerracotta}).addTag(ItemTags.STONE_BRICKS);
        this.tag(ModTags.crafterProductExclusions.get(TagConstants.CRAFTING_STONE_SMELTERY), "Stonesmelter Crafting Excluded Products");
        this.tag(ModTags.crafterIngredient.get("reduceable"), "Reduceable Ingredients").add((Object[])new Item[]{Items.BOOK, Items.PAPER, Items.SUGAR}).addTag(ItemTags.FISHES).add((Object)Items.BEEF).add((Object)Items.MUTTON).add((Object)Items.CHICKEN).add((Object)Items.PORKCHOP).add((Object)Items.RABBIT).add((Object)Items.POTATO).add((Object)Items.STICK).add((Object)Items.LEATHER).add((Object)Items.RABBIT_HIDE).add((Object)Items.NETHER_BRICK).add((Object)Items.POPPED_CHORUS_FRUIT).add((Object)Items.PRISMARINE_SHARD).add((Object)Items.PRISMARINE_CRYSTALS).addTags(new TagKey[]{Tags.Items.GLASS_BLOCKS, Tags.Items.GLASS_PANES}).addTag(Tags.Items.CROPS_WHEAT).addTag(Tags.Items.STRINGS).addTags(new TagKey[]{Tags.Items.NUGGETS, Tags.Items.INGOTS}).addTags(new TagKey[]{Tags.Items.STONES, Tags.Items.COBBLESTONES}).addTags(new TagKey[]{Tags.Items.GRAVELS, Tags.Items.SANDS}).addTags(new TagKey[]{Tags.Items.DUSTS, Tags.Items.GEMS}).addTag(ItemTags.WOOL).addTags(new TagKey[]{ItemTags.LOGS, ItemTags.PLANKS, ItemTags.STONE_BRICKS});
        this.tag(ModTags.crafterProductExclusions.get("reduceable"), "Not Reduceable Ingredients").add((Object)Items.GLOWSTONE).add((Object)ModItems.breadDough).add((Object)ModItems.cookieDough).add((Object)ModItems.rawPumpkinPie).add((Object)ModItems.cakeBatter).addTags(new TagKey[]{Tags.Items.STONES, Tags.Items.COBBLESTONES}).addTags(new TagKey[]{Tags.Items.GRAVELS, Tags.Items.SANDS}).addTags(new TagKey[]{Tags.Items.INGOTS, storageBlocks});
        this.tag(ModTags.ignoreNBT, "Ignore NBT").addTag(ItemTags.BANNERS);
        super.tag(Tags.Items.FOODS).add((Object[])ModItems.getAllFoods());
        super.tag(Tags.Items.FOODS_BREAD).add((Object[])new Item[]{ModItems.milkyBread, ModItems.sugaryBread, ModItems.goldenBread, ModItems.chorusBread, ModItems.flatbread, ModItems.hand_pie, ModItems.lembas_scone, ModItems.manchet_bread, ModItems.muffin, ModItems.stew_trencher, ModItems.stuffed_pita});
        super.tag(Tags.Items.FOODS_CANDY).add((Object)ModItems.hand_pie).add((Object)ModItems.muffin);
        super.tag(Tags.Items.FOODS_COOKED_MEAT).add((Object)ModItems.lamb_stew);
        super.tag(Tags.Items.FOODS_GOLDEN).add((Object)ModItems.goldenBread);
        super.tag(Tags.Items.FOODS_SOUP).add((Object)ModItems.cabochis).add((Object)ModItems.lamb_stew).add((Object)ModItems.pottage);
        super.tag(Tags.Items.FOODS_VEGETABLE).add((Object)ModItems.cabochis).add((Object)ModItems.eggplant_dolma).add((Object)ModItems.pottage).add((Object)ModItems.stuffed_pepper).add((Object)ModItems.stuffed_pita);
    }

    @NotNull
    private static Item[] getDomumExtra(ExtraBlockType ... types) {
        HashSet<ExtraBlockType> typesSet = new HashSet<ExtraBlockType>(Arrays.asList(types));
        return (Item[])com.ldtteam.domumornamentum.block.ModBlocks.getInstance().getExtraTopBlocks().stream().filter(extra -> typesSet.contains(extra.getType())).map(Block::asItem).toArray(Item[]::new);
    }
}

