/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFlorist;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.tileentities.TileEntityCompostedDirt;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFlorist
extends AbstractEntityAIInteract<JobFlorist, BuildingFlorist> {
    private static final long MAX_DISTANCE = 50L;
    private static final int HARVEST_ACTIONS_TO_DUMP = 10;
    private static final double PERCENT_CHANGE_FOR_GROWTH = 0.2;
    private static final double BASE_XP_GAIN = 0.5;
    private static final int COMPOST_REQUEST_QTY = 16;
    private static final int BASE_BLOCK_MINING_DELAY = 10;
    private static final double PER_LEVEL_BONUS = 0.1;
    private static final double MAX_BONUS = 5.0;
    private static final VisibleCitizenStatus GARDENING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/florist.png"), "com.minecolonies.gui.visiblestatus.florist");
    private static final double XP_PER_FLOWER = 2.0;
    public static final String RENDER_META_FLOWERS = "flowers";
    private BlockPos harvestPosition;
    private BlockPos compostPosition;

    public EntityAIWorkFlorist(@NotNull JobFlorist job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<AIWorkerState>(AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 200), new AITarget<Object>(AIWorkerState.FLORIST_HARVEST, this::harvest, 20), new AITarget<Object>(AIWorkerState.FLORIST_COMPOST, this::compost, 20));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata((InventoryUtils.hasItemInItemHandler(this.worker.getItemHandlerCitizen(), stack -> stack.is(ItemTags.FLOWERS)) ? RENDER_META_FLOWERS : "") + (this.getState() == AIWorkerState.IDLE ? "" : "working"));
    }

    private IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((BuildingFlorist)this.building).getPlantGround().isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.florist.noplantground", (Object[])new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        if (!this.checkOrEquipShears()) {
            return AIWorkerState.IDLE;
        }
        this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        long distance = BlockPosUtil.getDistance2D(this.worker.blockPosition(), ((BuildingFlorist)this.building).getPosition());
        if (distance > 50L && !this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST);
        if (amountOfCompostInInv <= 0) {
            int amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, ItemStackUtils.IS_COMPOST, 1);
            if (amountOfCompostInBuilding > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ItemStackUtils.IS_COMPOST, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)ModItems.compost, 16));
        }
        this.harvestPosition = this.areThereFlowersToGather();
        if (this.harvestPosition != null) {
            return AIWorkerState.FLORIST_HARVEST;
        }
        if (amountOfCompostInInv <= 0) {
            if (!WorkerUtil.isThereCompostedLand((BuildingFlorist)this.building, (Level)this.world)) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.florist.nocompost", (Object[])new Object[0]), ChatPriority.BLOCKING));
                return AIWorkerState.START_WORKING;
            }
            return AIWorkerState.DECIDE;
        }
        this.compostPosition = this.getFirstNotCompostedLand();
        return AIWorkerState.FLORIST_COMPOST;
    }

    private IAIState compost() {
        if (this.compostPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (!this.walkToWorkPos(this.compostPosition)) {
            return this.getState();
        }
        BlockEntity entity = this.world.getBlockEntity(this.compostPosition);
        if (entity instanceof TileEntityCompostedDirt) {
            @Nullable ItemStack stack = ((BuildingFlorist)this.building).getFlowerToGrow();
            if (stack != null) {
                if (this.worker.getRandom().nextInt(200 - this.getPrimarySkillLevel()) < 0 || InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST)) {
                    ((TileEntityCompostedDirt)entity).compost(0.2 - (double)((BuildingFlorist)this.building).getBuildingLevel() * 0.01, ((BuildingFlorist)this.building).getFlowerToGrow());
                }
            } else {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.florist.noflowers", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.compostPosition = null;
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvest() {
        if (this.harvestPosition == null || !this.checkOrEquipShears()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (!this.walkToWorkPos(this.harvestPosition)) {
            return this.getState();
        }
        List<String> flowerDrops = EntityAIWorkFlorist.getFlowerDropAtPos((Level)this.world, this.harvestPosition);
        if (!this.mineBlock(this.harvestPosition)) {
            return this.getState();
        }
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        for (String drop : flowerDrops) {
            StatsUtil.trackStatByName((IBuilding)this.building, "flowers_picked", drop, 1);
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.harvestPosition = null;
        return AIWorkerState.START_WORKING;
    }

    @Override
    public boolean holdEfficientTool(@NotNull BlockState target, BlockPos pos) {
        int bestSlot = this.getMostEfficientTool(target, pos);
        if (bestSlot == -10) {
            return true;
        }
        return super.holdEfficientTool(target, pos);
    }

    private boolean checkOrEquipShears() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shears.get())) {
            return false;
        }
        int shearSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.worker.getInventoryCitizen(), (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, ((BuildingFlorist)this.building).getMaxEquipmentLevel());
        if (shearSlot >= 0) {
            CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, shearSlot);
            return true;
        }
        return false;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10 * ((BuildingFlorist)this.building).getBuildingLevel();
    }

    @Override
    public int getBlockMiningTime(@NotNull BlockState state, @NotNull BlockPos pos) {
        return 10 * (int)(1.0 + Math.max(0.0, 5.0 - 0.1 * ((double)this.getSecondarySkillLevel() / 2.0)));
    }

    @Nullable
    private BlockPos areThereFlowersToGather() {
        for (BlockPos pos : ((BuildingFlorist)this.building).getPlantGround()) {
            if (this.world.isEmptyBlock(pos.above())) continue;
            return pos.above();
        }
        return null;
    }

    private BlockPos getFirstNotCompostedLand() {
        for (BlockPos pos : ((BuildingFlorist)this.building).getPlantGround()) {
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.world, pos)) continue;
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (((TileEntityCompostedDirt)entity).isComposted()) continue;
                return pos;
            }
            ((BuildingFlorist)this.building).removePlantableGround(pos);
        }
        return null;
    }

    @Override
    public Class<BuildingFlorist> getExpectedBuildingClass() {
        return BuildingFlorist.class;
    }

    protected static List<String> getFlowerDropAtPos(Level world, BlockPos pos) {
        ArrayList<String> flowerDrops = new ArrayList<String>();
        BlockState state = world.getBlockState(pos);
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null);
        for (ItemStack drop : drops) {
            if (!drop.is(ItemTags.FLOWERS)) continue;
            flowerDrops.add(drop.getItem().getDescriptionId());
        }
        return flowerDrops;
    }
}

