/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.combat;

import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTableEntry;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;

public class TargetAI<T extends Mob>
implements IStateAI {
    protected final T user;
    protected LivingEntity target;

    public TargetAI(T user, int targetFrequency, ITickRateStateMachine stateMachine) {
        this.user = user;
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::checkForTarget, () -> CombatAIStates.ATTACKING, 5));
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::searchNearbyTarget, () -> CombatAIStates.ATTACKING, targetFrequency));
    }

    protected boolean checkForTarget() {
        ThreatTableEntry nextTarget;
        if (this.target != null && !this.target.isAlive()) {
            this.onTargetDied(this.target);
            this.target = null;
        }
        if ((nextTarget = ((IThreatTableEntity)this.user).getThreatTable().getTarget()) == null) {
            return false;
        }
        if (this.isEntityValidTarget(nextTarget.getEntity())) {
            if (this.target != nextTarget.getEntity()) {
                this.target = nextTarget.getEntity();
                this.onTargetChange(this.target);
            }
            return true;
        }
        this.resetTarget();
        return false;
    }

    public boolean isEntityValidTarget(LivingEntity target) {
        if (target == this.user || target == null || !target.isAlive() || !this.isWithinPersecutionDistance(target) || target instanceof FakePlayer) {
            return false;
        }
        if (target == this.user.getLastHurtByMob()) {
            return true;
        }
        return this.isAttackableTarget(target);
    }

    public void resetTarget() {
        if (this.target == null) {
            return;
        }
        if (this.user.getLastHurtMob() == this.target) {
            this.user.setLastHurtMob(null);
        }
        if (this.user.getLastHurtByMob() == this.target) {
            this.user.setLastHurtByMob(null);
        }
        ((IThreatTableEntity)this.user).getThreatTable().markInvalidTarget();
        this.target = null;
    }

    protected boolean searchNearbyTarget() {
        if (this.checkForTarget()) {
            return true;
        }
        List entities = this.user.level().getEntitiesOfClass(LivingEntity.class, this.getSearchArea());
        if (entities.isEmpty()) {
            return false;
        }
        boolean foundTarget = false;
        for (LivingEntity entity : entities) {
            if (!entity.isAlive()) continue;
            if (this.skipSearch(entity)) {
                return false;
            }
            if (!this.isEntityValidTarget(entity) || !this.user.getSensing().hasLineOfSight((Entity)entity)) continue;
            ((IThreatTableEntity)this.user).getThreatTable().addThreat(entity, 0);
            foundTarget = true;
        }
        return foundTarget;
    }

    protected boolean skipSearch(LivingEntity entity) {
        return false;
    }

    protected AABB getSearchArea() {
        BlockPos raiderPos = this.user.blockPosition();
        Direction randomDirection = Direction.from3DDataValue((int)(this.user.getRandom().nextInt(4) + 2));
        int searchRange = this.getSearchRange();
        double x1 = raiderPos.getX() + Math.max(searchRange * randomDirection.getStepX() + 16, 16);
        double x2 = raiderPos.getX() + Math.min(searchRange * randomDirection.getStepX() - 16, -16);
        double y1 = raiderPos.getY() + this.getYSearchRange();
        double y2 = raiderPos.getY() - this.getYSearchRange();
        double z1 = raiderPos.getZ() + Math.max(searchRange * randomDirection.getStepZ() + 16, 16);
        double z2 = raiderPos.getZ() + Math.min(searchRange * randomDirection.getStepZ() - 16, -16);
        return new AABB(x1, y1, z1, x2, y2, z2);
    }

    protected int getYSearchRange() {
        return 3;
    }

    protected int getSearchRange() {
        return 16;
    }

    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof Enemy && !this.user.getClass().isInstance(target);
    }

    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }

    protected void onTargetDied(LivingEntity target) {
    }

    protected void onTargetChange(LivingEntity newTarget) {
        this.user.setTarget(newTarget);
    }
}

