/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.debug.gui.DebugWindowCitizen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DebugOutputMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"debug_output", DebugOutputMessage::new);
    private Component debugInfo;
    private boolean clear = false;

    public DebugOutputMessage(Component message, boolean clear) {
        super(TYPE);
        this.debugInfo = message;
        this.clear = clear;
    }

    protected DebugOutputMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, TYPE);
        this.debugInfo = (Component)Utils.deserializeCodecMess(ComponentSerialization.STREAM_CODEC, buf);
        this.clear = buf.readBoolean();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(ComponentSerialization.STREAM_CODEC, buf, this.debugInfo);
        buf.writeBoolean(this.clear);
    }

    protected void onExecute(IPayloadContext iPayloadContext, Player player) {
        if (this.clear) {
            DebugWindowCitizen.outputMessage = Component.literal((String)"").append(this.debugInfo);
        } else {
            DebugWindowCitizen.outputMessage.append((Component)Component.literal((String)"\n")).append(this.debugInfo);
        }
    }
}

