/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.research.GlobalResearch;
import com.minecolonies.core.research.GlobalResearchBranch;
import com.minecolonies.core.research.GlobalResearchEffect;
import com.minecolonies.core.research.ResearchEffectCategory;
import com.minecolonies.core.util.GsonHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.Tuple;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Function<ResourceLocation, String> DEFAULT_RESEARCH_NAME = effectId -> String.format("com.%s.research.%s.name", effectId.getNamespace(), effectId.getPath().replaceAll("[ /]", "."));
    private static final Function<ResourceLocation, String> DEFAULT_RESEARCH_EFFECT_NAME = effectId -> String.format("com.%s.research.%s.description", effectId.getNamespace(), effectId.getPath().replaceAll("[ /]", "."));
    private static final Supplier<JsonArray> DEFAULT_RESEARCH_EFFECT_LEVELS = () -> {
        JsonArray defaultArray = new JsonArray();
        defaultArray.add((Number)1);
        return defaultArray;
    };
    public static final String EFFECT_PROP = "effect";
    public static final String EFFECT_LEVELS_PROP = "levels";
    public static final String RESEARCH_NAME_PROP = "name";
    public static final String RESEARCH_SUBTITLE_PROP = "subtitle";
    public static final String RESEARCH_BRANCH_PROP = "branch";
    public static final String RESEARCH_LEVEL_PROP = "researchLevel";
    public static final String RESEARCH_SORT_PROP = "sortOrder";
    public static final String RESEARCH_REQUIREMENT_TYPE_PROP = "type";
    public static final String RESEARCH_HIDDEN_PROP = "hidden";
    public static final String RESEARCH_AUTOSTART_PROP = "autostart";
    public static final String RESEARCH_INSTANT_PROP = "instant";
    public static final String RESEARCH_EFFECTS_PROP = "effects";
    public static final String RESEARCH_EFFECTS_EFFECT_ID_PROP = "id";
    public static final String RESEARCH_EFFECTS_LEVEL_PROP = "level";
    public static final String RESEARCH_REMOVE_PROP = "remove";
    private static final String RESEARCH_EXCLUSIVE_CHILD_PROP = "exclusiveChildResearch";
    private static final String RESEARCH_PARENT_PROP = "parentResearch";
    private static final String RESEARCH_NO_RESET_PROP = "no-reset";
    private static final String RESEARCH_REQUIREMENTS_PROP = "requirements";
    private static final String RESEARCH_COSTS_PROP = "costs";

    public ResearchListener() {
        super(GSON, "researches");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManagerIn, @NotNull ProfilerFiller profilerIn) {
        Log.getLogger().info("Research loading...");
        Map<ResourceLocation, ResearchEffectCategory> effectCategories = this.parseResearchEffectCategories(object);
        Tuple<Collection<ResourceLocation>, Collection<ResourceLocation>> removeResearchesAndBranches = this.parseRemoveResearches(object);
        Map<ResourceLocation, GlobalResearch> researchMap = this.parseResearches(object, effectCategories, (Collection)removeResearchesAndBranches.getA(), (Collection)removeResearchesAndBranches.getB());
        IGlobalResearchTree researchTree = this.calcResearchTree(researchMap);
        this.parseResearchBranches(object, researchTree);
        Log.getLogger().info("Research loaded. Located {} branches, {} researches and {} effects.", (Object)researchTree.getBranches().size(), (Object)researchMap.size(), (Object)effectCategories.size());
    }

    private Map<ResourceLocation, ResearchEffectCategory> parseResearchEffectCategories(Map<ResourceLocation, JsonElement> object) {
        HashMap<ResourceLocation, ResearchEffectCategory> effectCategories = new HashMap<ResourceLocation, ResearchEffectCategory>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation effectId = entry.getKey();
            JsonObject effectJson = entry.getValue().getAsJsonObject();
            if (!effectJson.has(EFFECT_PROP)) continue;
            String effectName = GsonHelper.getAsString(effectJson, RESEARCH_NAME_PROP, DEFAULT_RESEARCH_EFFECT_NAME, effectId);
            String effectSubtitle = GsonHelper.getAsString((JsonObject)effectJson, (String)RESEARCH_SUBTITLE_PROP, (String)"");
            ArrayList<Double> levels = new ArrayList<Double>();
            for (JsonElement levelElement : GsonHelper.getAsJsonArray(effectJson, EFFECT_LEVELS_PROP, DEFAULT_RESEARCH_EFFECT_LEVELS)) {
                if (!GsonHelper.isNumberValue((JsonElement)levelElement)) continue;
                levels.add(levelElement.getAsNumber().doubleValue());
            }
            effectCategories.put(effectId, new ResearchEffectCategory(effectId, effectName, effectSubtitle, levels));
        }
        return effectCategories;
    }

    private Map<ResourceLocation, GlobalResearch> parseResearches(Map<ResourceLocation, JsonElement> object, Map<ResourceLocation, ResearchEffectCategory> effectCategories, Collection<ResourceLocation> removeResearches, Collection<ResourceLocation> removeBranches) {
        HashMap<ResourceLocation, GlobalResearch> researchMap = new HashMap<ResourceLocation, GlobalResearch>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation researchId = entry.getKey();
            JsonObject researchJson = entry.getValue().getAsJsonObject();
            if (researchJson.has(EFFECT_PROP) || researchJson.has("branch-name") || researchJson.has("base-time") || researchJson.has("branch-type")) continue;
            if (removeResearches.contains(researchId)) {
                if (!((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchDebugLog.get()).booleanValue()) continue;
                Log.getLogger().info("{} was removed by data pack.", (Object)researchId);
                continue;
            }
            ResourceLocation branch = GsonHelper.getAsResourceLocation(researchJson, RESEARCH_BRANCH_PROP, null);
            if (branch == null) {
                Log.getLogger().warn("Research '{}' is missing the required '{}' property.", (Object)researchId, (Object)RESEARCH_BRANCH_PROP);
                continue;
            }
            if (removeBranches.contains(ResourceLocation.parse((String)researchJson.get(RESEARCH_BRANCH_PROP).getAsString()))) {
                if (!((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchDebugLog.get()).booleanValue()) continue;
                Log.getLogger().info("{} was removed, as its branch had been removed by data pack.", (Object)researchId);
                continue;
            }
            ResourceLocation parent = GsonHelper.getAsResourceLocation(researchJson, RESEARCH_PARENT_PROP, null);
            TranslatableContents name = new TranslatableContents(GsonHelper.getAsString(researchJson, RESEARCH_NAME_PROP, DEFAULT_RESEARCH_NAME, researchId), null, TranslatableContents.NO_ARGS);
            TranslatableContents subtitle = new TranslatableContents(GsonHelper.getAsString((JsonObject)researchJson, (String)RESEARCH_SUBTITLE_PROP, (String)""), null, TranslatableContents.NO_ARGS);
            int depth = GsonHelper.getAsInt((JsonObject)researchJson, (String)RESEARCH_LEVEL_PROP, (int)1);
            int sortOrder = GsonHelper.getAsInt((JsonObject)researchJson, (String)RESEARCH_SORT_PROP, (int)1000);
            boolean onlyChild = GsonHelper.getAsBoolean((JsonObject)researchJson, (String)RESEARCH_EXCLUSIVE_CHILD_PROP, (boolean)false);
            boolean hidden = GsonHelper.getAsBoolean((JsonObject)researchJson, (String)RESEARCH_HIDDEN_PROP, (boolean)false);
            boolean instant = GsonHelper.getAsBoolean((JsonObject)researchJson, (String)RESEARCH_INSTANT_PROP, (boolean)false);
            boolean autostart = GsonHelper.getAsBoolean((JsonObject)researchJson, (String)RESEARCH_AUTOSTART_PROP, (boolean)false);
            boolean immutable = GsonHelper.getAsBoolean((JsonObject)researchJson, (String)RESEARCH_NO_RESET_PROP, (boolean)false);
            List<IResearchRequirement> requirements = this.parseResearchRequirements(researchId, GsonHelper.getAsJsonArray((JsonObject)researchJson, (String)RESEARCH_REQUIREMENTS_PROP, (JsonArray)new JsonArray()));
            List<SizedIngredient> costs = this.parseResearchCosts(researchId, GsonHelper.getAsJsonArray((JsonObject)researchJson, (String)RESEARCH_COSTS_PROP, (JsonArray)new JsonArray()), GsonHelper.getAsJsonArray((JsonObject)researchJson, (String)RESEARCH_REQUIREMENTS_PROP, (JsonArray)new JsonArray()));
            List<GlobalResearchEffect> effects = this.parseResearchEffects(researchId, GsonHelper.getAsJsonArray((JsonObject)researchJson, (String)RESEARCH_EFFECTS_PROP, (JsonArray)new JsonArray()), effectCategories);
            GlobalResearch research = new GlobalResearch(researchId, parent, branch, name, subtitle, depth, sortOrder, onlyChild, hidden, autostart, instant, immutable);
            requirements.forEach(research::addRequirement);
            costs.forEach(research::addCost);
            effects.forEach(research::addEffect);
            researchMap.put(researchId, research);
        }
        return researchMap;
    }

    private List<IResearchRequirement> parseResearchRequirements(ResourceLocation researchId, JsonArray jsonRequirements) {
        ArrayList<IResearchRequirement> requirements = new ArrayList<IResearchRequirement>();
        for (int index = 0; index < jsonRequirements.size(); ++index) {
            JsonObject jsonRequirement = jsonRequirements.get(index).getAsJsonObject();
            ResourceLocation type = GsonHelper.getAsResourceLocation(jsonRequirement, RESEARCH_REQUIREMENT_TYPE_PROP, null);
            if (type == null) {
                Log.getLogger().warn("Research '{}' requirement #{} is missing the required '{}' property.", (Object)researchId, (Object)index, (Object)RESEARCH_REQUIREMENT_TYPE_PROP);
                continue;
            }
            Optional researchRequirementEntry = IMinecoloniesAPI.getInstance().getResearchRequirementRegistry().getOptional(type);
            if (researchRequirementEntry.isPresent()) {
                try {
                    requirements.add(((ModResearchRequirements.ResearchRequirementEntry)researchRequirementEntry.get()).readFromJson(jsonRequirement));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Research '{}' requirement #{} is invalid. {}", (Object)researchId, (Object)index, (Object)ex.getMessage());
                }
                continue;
            }
            Log.getLogger().warn("Research '{}' requirement #{} is invalid, type '{}' does not exist.", (Object)researchId, (Object)index, (Object)type);
        }
        return requirements;
    }

    private List<SizedIngredient> parseResearchCosts(ResourceLocation researchId, JsonArray jsonCosts, JsonArray jsonRequirements) {
        int index;
        ArrayList<SizedIngredient> costs = new ArrayList<SizedIngredient>();
        for (index = 0; index < jsonCosts.size(); ++index) {
            JsonElement jsonCost = jsonCosts.get(index);
            costs.add((SizedIngredient)Utils.deserializeCodecMessFromJson(SizedIngredient.FLAT_CODEC, this.getRegistryLookup(), jsonCost));
        }
        for (index = 0; index < jsonRequirements.size(); ++index) {
            JsonObject jsonRequirement = jsonRequirements.get(index).getAsJsonObject();
            if (!jsonRequirement.has("items")) continue;
            Log.getLogger().warn("Research '{}' requirement #{} is deprecated. Cost requirements should be put in the 'costs' array.", (Object)researchId, (Object)index);
            costs.add((SizedIngredient)Utils.deserializeCodecMessFromJson(SizedIngredient.FLAT_CODEC, this.getRegistryLookup(), jsonRequirement.get("items")));
        }
        return costs;
    }

    private List<GlobalResearchEffect> parseResearchEffects(ResourceLocation researchId, JsonArray researchEffectsArray, Map<ResourceLocation, ResearchEffectCategory> researchEffectCategories) {
        ArrayList<GlobalResearchEffect> effects = new ArrayList<GlobalResearchEffect>();
        for (int index = 0; index < researchEffectsArray.size(); ++index) {
            ResearchEffectCategory researchEffectCategory;
            int effectLevel;
            ResourceLocation effectId;
            JsonElement researchEffectElement = researchEffectsArray.get(index);
            JsonObject researchEffectJson = researchEffectElement.getAsJsonObject();
            if (researchEffectJson.has(RESEARCH_EFFECTS_EFFECT_ID_PROP)) {
                effectId = GsonHelper.getAsResourceLocation(researchEffectJson, RESEARCH_EFFECTS_EFFECT_ID_PROP, null);
                effectLevel = GsonHelper.getAsInt((JsonObject)researchEffectJson, (String)RESEARCH_EFFECTS_LEVEL_PROP, (int)1);
                if (effectId == null) {
                    Log.getLogger().warn("Research '{}' effect #{} is missing the required '{}' property.", (Object)researchId, (Object)index, (Object)RESEARCH_EFFECTS_EFFECT_ID_PROP);
                }
            } else {
                Log.getLogger().warn("Research '{}' effect #{} key is the effect ID, this method is deprecated, please use the object setup instead, for more information on the new structure see the wiki.", (Object)researchId, (Object)index);
                Iterator iterator = researchEffectElement.getAsJsonObject().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)researchEffectElement.getAsJsonObject().entrySet().iterator().next();
                    effectId = ResourceLocation.parse((String)((String)next.getKey()));
                    if (!GsonHelper.isNumberValue((JsonElement)((JsonElement)next.getValue()))) {
                        Log.getLogger().warn("Research '{}' effect #{} value is not a number.", (Object)researchId, (Object)index);
                        continue;
                    }
                    effectLevel = ((JsonElement)next.getValue()).getAsInt();
                } else {
                    Log.getLogger().warn("Research '{}' effect #{} is empty.", (Object)researchId, (Object)index);
                    continue;
                }
            }
            if ((researchEffectCategory = researchEffectCategories.get(effectId)) == null) {
                Log.getLogger().warn("Research '{}' effect #{} looking for non-existent research effect {}", (Object)researchId, (Object)index, (Object)effectId);
                continue;
            }
            if (effectLevel > researchEffectCategory.getMaxLevel()) {
                Log.getLogger().warn("Research '{}' effect #{} requested higher effect strength than exists.", (Object)researchId, (Object)index);
                continue;
            }
            effects.add(new GlobalResearchEffect(effectId, researchEffectCategory.getName(), researchEffectCategory.getSubtitle(), researchEffectCategory.get(effectLevel), researchEffectCategory.getDisplay(effectLevel)));
        }
        return effects;
    }

    private Tuple<Collection<ResourceLocation>, Collection<ResourceLocation>> parseRemoveResearches(Map<ResourceLocation, JsonElement> object) {
        HashSet<ResourceLocation> removeResearches = new HashSet<ResourceLocation>();
        HashSet<ResourceLocation> removeBranches = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            JsonObject researchJson = entry.getValue().getAsJsonObject();
            if (!researchJson.has(RESEARCH_REMOVE_PROP)) continue;
            if (researchJson.has("branch-name") || researchJson.has("base-time")) {
                if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonArray()) {
                    for (JsonElement remove : researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonArray()) {
                        if (!remove.isJsonPrimitive() || !remove.getAsJsonPrimitive().isString()) continue;
                        removeBranches.add(ResourceLocation.parse((String)remove.getAsString()));
                    }
                    continue;
                }
                if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isString()) {
                    removeBranches.add(ResourceLocation.parse((String)researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().getAsString()));
                    continue;
                }
                if (!researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() || !researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isBoolean() || !researchJson.get(RESEARCH_REMOVE_PROP).getAsBoolean()) continue;
                removeBranches.add(entry.getKey());
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonArray()) {
                for (JsonElement remove : researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonArray()) {
                    if (!remove.isJsonPrimitive() || !remove.getAsJsonPrimitive().isString()) continue;
                    removeResearches.add(ResourceLocation.parse((String)remove.getAsString()));
                }
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isString()) {
                removeResearches.add(ResourceLocation.parse((String)researchJson.get(RESEARCH_REMOVE_PROP).getAsString()));
                continue;
            }
            if (researchJson.get(RESEARCH_REMOVE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_REMOVE_PROP).getAsJsonPrimitive().isBoolean() && researchJson.get(RESEARCH_REMOVE_PROP).getAsBoolean()) {
                removeResearches.add(entry.getKey());
                continue;
            }
            Log.getLogger().error("{} is a research remove, but does not contain all required fields.  Research Removes must have remove:boolean and id:string.", (Object)entry.getKey());
        }
        return new Tuple(removeResearches, removeBranches);
    }

    private IGlobalResearchTree calcResearchTree(Map<ResourceLocation, GlobalResearch> researchMap) {
        int previousResearchCount;
        IGlobalResearchTree researchTree = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree();
        researchTree.reset();
        int currentResearchCount = researchMap.size();
        do {
            Iterator<Map.Entry<ResourceLocation, GlobalResearch>> iterator = researchMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, GlobalResearch> entry = iterator.next();
                ResourceLocation researchId = entry.getKey();
                GlobalResearch research = entry.getValue();
                @Nullable GlobalResearch parent = researchMap.get(research.getParent());
                if (parent == null && research.getDepth() > 1) {
                    Log.getLogger().error("Research '{}' could not be attached to tree. Parent does not exist.", (Object)researchId);
                    iterator.remove();
                    continue;
                }
                int depthOffset = research.getDepth() - Optional.ofNullable(parent).map(GlobalResearch::getDepth).orElse(0);
                if (depthOffset == 1) continue;
                if (depthOffset < 1) {
                    Log.getLogger().error("Research '{}' could not be attached to tree. Chosen parent is invalid, parent is a child or a sibling of this research.", (Object)researchId);
                }
                if (depthOffset > 1) {
                    Log.getLogger().error("Research '{}' could not be attached to tree. Parent cannot be set multiple levels deep, research must be a direct child of the parent.", (Object)researchId);
                }
                iterator.remove();
            }
            previousResearchCount = currentResearchCount;
        } while ((currentResearchCount = researchMap.size()) != previousResearchCount);
        for (GlobalResearch research : researchMap.values()) {
            if (research.getParent() != null) {
                GlobalResearch parent = researchMap.get(research.getParent());
                parent.addChild(research);
            }
            researchTree.addResearch(research.getBranch(), research, true);
        }
        return researchTree;
    }

    private void parseResearchBranches(Map<ResourceLocation, JsonElement> object, IGlobalResearchTree researchTree) {
        for (ResourceLocation branchId : researchTree.getBranches()) {
            if (object.containsKey(branchId)) {
                researchTree.addBranchData(branchId, new GlobalResearchBranch(branchId, object.get(branchId).getAsJsonObject()));
                continue;
            }
            researchTree.addBranchData(branchId, new GlobalResearchBranch(branchId));
        }
    }
}

