/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.commandTypes;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public interface IMCColonyOfficerCommand
extends IMCCommand {
    @Override
    default public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).hasPermission(4)) {
            return true;
        }
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return false;
        }
        IColony colony = ColonyIdArgument.tryGetColony(context, "colonyID", true);
        if (colony == null) {
            return false;
        }
        return IMCCommand.isPlayerOped((Player)sender) || colony.getPermissions().getRank((Player)sender).isColonyManager();
    }
}

