/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.WarehouseConcreteRequestResolver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class WarehouseConcreteRequestResolverFactory
implements IRequestResolverFactory<WarehouseConcreteRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends WarehouseConcreteRequestResolver> getFactoryOutputType() {
        return TypeToken.of(WarehouseConcreteRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public WarehouseConcreteRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new WarehouseConcreteRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull WarehouseConcreteRequestResolver warehouseConcreteRequestResolver) {
        CompoundTag compound = new CompoundTag();
        compound.put(NBT_TOKEN, (Tag)controller.serializeTag(provider, warehouseConcreteRequestResolver.getId()));
        compound.put(NBT_LOCATION, (Tag)controller.serializeTag(provider, warehouseConcreteRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public WarehouseConcreteRequestResolver deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserializeTag(provider, nbt.getCompound(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserializeTag(provider, nbt.getCompound(NBT_LOCATION));
        return new WarehouseConcreteRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, WarehouseConcreteRequestResolver input, RegistryFriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public WarehouseConcreteRequestResolver deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new WarehouseConcreteRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return 18;
    }
}

