/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.management.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.management.IResolverHandler;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.core.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolverHandler
implements IResolverHandler {
    private final IStandardRequestManager manager;
    private List<IToken<?>> tempBlackList = new ArrayList();

    public ResolverHandler(IStandardRequestManager manager) {
        this.manager = manager;
    }

    @Override
    public IRequestManager getManager() {
        return this.manager;
    }

    @Override
    public Collection<IToken<?>> registerResolvers(IRequestResolver<?> ... resolvers) {
        return Arrays.stream(resolvers).map(this::registerResolver).collect(Collectors.toList());
    }

    @Override
    public IToken<?> registerResolver(IRequestResolver<? extends IRequestable> resolver) {
        if (this.manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(resolver.getId())) {
            throw new IllegalArgumentException("The token attached to this resolver is already registered. Cannot register twice!");
        }
        if (this.manager.getRequestResolverIdentitiesDataStore().getIdentities().containsValue(resolver)) {
            throw new IllegalArgumentException("The given resolver is already registered with a different token. Cannot register twice!");
        }
        this.manager.getRequestResolverIdentitiesDataStore().getIdentities().put(resolver.getId(), resolver);
        Set<TypeToken<?>> resolverTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        resolverTypes.remove(TypeConstants.OBJECT);
        resolverTypes.forEach(c -> {
            if (!this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().containsKey(c)) {
                this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().put((TypeToken)c, new ArrayList());
            }
            this.manager.log("Registering resolver: " + String.valueOf(resolver) + " with request type: " + String.valueOf(c));
            this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(c).add(resolver.getId());
        });
        return resolver.getId();
    }

    @Override
    public Collection<IToken<?>> registerResolvers(Collection<IRequestResolver<?>> resolvers) {
        return resolvers.stream().map(this::registerResolver).collect(Collectors.toList());
    }

    @Override
    public void removeResolver(IToken<?> token) {
        if (!this.manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The token is unknown to this manager.");
        }
        this.removeResolver(this.getResolver(token));
    }

    @Override
    public void removeResolver(IRequestResolver<?> resolver) {
        IRequestResolver<? extends IRequestable> registeredResolver = this.getResolver(resolver.getId());
        if (!registeredResolver.equals(resolver)) {
            throw new IllegalArgumentException("The given resolver and the resolver that is registered with its token are not the same.");
        }
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(registeredResolver.getId()) && !this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(registeredResolver.getId()).isEmpty()) {
            throw new IllegalArgumentException("Cannot remove a resolver that is still in use. Reassign all registered requests before removing");
        }
        this.removeResolverInternal(resolver);
    }

    @Override
    public void processResolverForRemoval(Collection<IToken<?>> assignedResolvers, IToken<?> resolverToken) {
        Validate.isTrue((boolean)assignedResolvers.contains(resolverToken));
        if (!this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolverToken) || this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken).isEmpty()) {
            this.removeResolverWithoutAssignedRequests(resolverToken);
            return;
        }
        this.removeResolverWithAssignedRequests(assignedResolvers, resolverToken);
    }

    @VisibleForTesting
    void removeResolverWithoutAssignedRequests(@NotNull IToken<?> resolverToken) {
        this.manager.log("Removing resolver without assigned requests: " + String.valueOf(resolverToken));
        this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolverToken);
        this.manager.getResolverHandler().removeResolver(resolverToken);
    }

    @VisibleForTesting
    void removeResolverWithAssignedRequests(@NotNull Collection<IToken<?>> assignedResolvers, IToken<?> resolverToken) {
        Validate.isTrue((boolean)assignedResolvers.contains(resolverToken));
        ArrayList assignedRequests = new ArrayList(this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken));
        this.manager.log("Starting reassignment of already registered requests registered to resolver with token: " + String.valueOf(resolverToken));
        this.tempBlackList.addAll(assignedResolvers);
        for (IToken requestToken : assignedRequests) {
            IRequest<?> req = this.manager.getRequestForToken(requestToken);
            for (IToken childReq : req.getChildren()) {
                this.manager.getRequestHandler().onRequestCancelledDirectly(childReq);
            }
        }
        assignedRequests = new ArrayList(this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken));
        for (IToken requestToken : assignedRequests) {
            this.manager.reassignRequest(requestToken, assignedResolvers);
        }
        this.tempBlackList.removeAll(assignedResolvers);
        this.removeResolverWithoutAssignedRequests(resolverToken);
        this.manager.log("Finished reassignment of already registered requests registered to resolver with token: " + String.valueOf(resolverToken));
    }

    @Override
    public Collection<IToken<?>> getRequestsAssignedToResolver(IRequestResolver<?> resolver) {
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getId())) {
            return this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId());
        }
        return Lists.newArrayList();
    }

    @Override
    public IRequestResolver<? extends IRequestable> getResolver(IToken<?> token) {
        if (!this.manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The given token for a resolver is not known to this manager!");
        }
        return (IRequestResolver)this.manager.getRequestResolverIdentitiesDataStore().getIdentities().get(token);
    }

    @Override
    public void removeResolverInternal(IRequestResolver<?> resolver) {
        this.manager.getRequestResolverIdentitiesDataStore().getIdentities().remove(resolver.getId());
        Set<TypeToken<?>> requestTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        requestTypes.remove(TypeConstants.OBJECT);
        requestTypes.forEach(c -> {
            this.manager.log("Removing resolver: " + String.valueOf(resolver) + " with request type: " + String.valueOf(c));
            this.manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(c).remove(resolver.getId());
        });
    }

    @Override
    public void removeResolvers(IRequestResolver<?> ... resolvers) {
        this.removeResolvers(Arrays.asList(resolvers));
    }

    @Override
    public void removeResolvers(Iterable<IRequestResolver<?>> resolvers) {
        resolvers.forEach(this::removeResolver);
    }

    @Override
    public void addRequestToResolver(IRequestResolver<?> resolver, IRequest<?> request) {
        if (!this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getId())) {
            this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().put(resolver.getId(), new HashSet());
        }
        this.manager.log("Adding request: " + String.valueOf(request) + " to resolver: " + String.valueOf(resolver));
        this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).add(request.getId());
        request.setState(new WrappedStaticStateRequestManager(this.manager), RequestState.ASSIGNED);
    }

    @Override
    public void removeRequestFromResolver(IRequestResolver<?> resolver, IRequest<?> request) {
        if (!this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getId())) {
            throw new IllegalArgumentException("The given resolver is unknown to this Manager");
        }
        if (!this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).contains(request.getId())) {
            throw new IllegalArgumentException("The given request is not registered to the given resolver.");
        }
        this.manager.log("Removing request: " + String.valueOf(request) + " from resolver: " + String.valueOf(resolver));
        this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).remove(request.getId());
        if (this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getId()).isEmpty()) {
            this.manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolver.getId());
        }
    }

    @Override
    public IRequestResolver<? extends IRequestable> getResolverForRequest(IToken<?> requestToken) {
        this.manager.getRequestHandler().getRequest(requestToken);
        @Nullable IToken resolverToken = (IToken)this.manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(requestToken);
        if (resolverToken == null) {
            throw new IllegalArgumentException("The given request: " + String.valueOf(requestToken) + " is not resolved.");
        }
        return (IRequestResolver)this.manager.getRequestResolverIdentitiesDataStore().getIdentities().get((Object)resolverToken);
    }

    @Override
    public IRequestResolver<? extends IRequestable> getResolverForRequest(IRequest<?> request) {
        return this.getResolverForRequest((IToken<?>)request.getId());
    }

    @Override
    public void onColonyUpdate(Predicate<IRequest<?>> shouldTriggerReassign) {
        this.manager.getRequestResolverIdentitiesDataStore().getIdentities().values().forEach(resolver -> resolver.onColonyUpdate(this.manager, shouldTriggerReassign));
    }

    @Override
    public boolean isBeingRemoved(IToken<?> id) {
        return this.tempBlackList.contains(id);
    }
}

