/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.permissions;

import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Explosions;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.blocks.BlockDecorationController;
import com.minecolonies.core.blocks.huts.BlockHutTownHall;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.permissions.Permissions;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;
    private final Map<UUID, Long> lastPlayerNotificationTick = new HashMap<UUID, Long>();
    private final Object2IntMap<UUID> playerAttempts = new Object2IntOpenHashMap();

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.EntityPlaceEvent event) {
        Action action;
        Action action2 = action = event.getPlacedBlock().getBlock() instanceof AbstractBlockHut ? Action.PLACE_HUTS : Action.PLACE_BLOCKS;
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue() && this.checkBlockEventDenied(event.getLevel(), event.getPos(), event.getEntity(), event.getPlacedBlock(), action)) {
            this.cancelEvent(event, event.getEntity(), this.colony, action, event.getPos());
        }
    }

    private boolean checkBlockEventDenied(LevelAccessor worldIn, BlockPos posIn, Entity entity, BlockState blockState, Action action) {
        if (entity instanceof Player) {
            @NotNull Player player = EntityUtils.getPlayerOfFakePlayer((Player)entity, entity.level());
            if (this.colony.isCoordInColony(entity.level(), posIn)) {
                if (blockState.getBlock() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                    return false;
                }
                return !this.colony.getPermissions().hasPermission(player, action);
            }
        }
        return false;
    }

    private <T extends Event> void cancelEvent(T event, @Nullable Entity entity, Colony colony, Action action, BlockPos pos) {
        this.cancelEvent(event, entity, colony, action, pos, ev -> ((ICancellableEvent)ev).setCanceled(true));
    }

    private <T extends Event> void cancelEvent(T event, @Nullable Entity entity, Colony colony, Action action, BlockPos pos, Consumer<T> eventCancellation) {
        if (event instanceof ICancellableEvent) {
            ICancellableEvent cancellableEvent = (ICancellableEvent)event;
            cancellableEvent.setCanceled(true);
        } else {
            eventCancellation.accept(event);
        }
        if (entity == null) {
            if (colony.hasTownHall()) {
                colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(null, "-", action, pos));
            }
            return;
        }
        if (colony.hasTownHall()) {
            colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(entity.getUUID(), entity.getName().getString(), action, pos));
        }
        if (entity instanceof FakePlayer) {
            return;
        }
        long worldTime = entity.level().getGameTime();
        if (!this.lastPlayerNotificationTick.containsKey(entity.getUUID()) || this.lastPlayerNotificationTick.get(entity.getUUID()) + 200L < worldTime) {
            MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo((Player)entity);
            this.lastPlayerNotificationTick.put(entity.getUUID(), worldTime);
            this.playerAttempts.put((Object)entity.getUUID(), 0);
        } else if ((Integer)this.playerAttempts.compute((Object)entity.getUUID(), (uuid, count) -> count == null ? 1 : count + 1) > 10 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.playerAttempts.put((Object)entity.getUUID(), 0);
            living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200));
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (event.getState().getBlock() instanceof AbstractBlockHut) {
            @Nullable IBuilding building = IColonyManager.getInstance().getBuilding((Level)world, event.getPos());
            if (building == null) {
                return;
            }
            if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue()) {
                building.destroy();
                return;
            }
            if (event.getState().getBlock() == ModBlocks.blockHutTownHall && !((BlockHutTownHall)event.getState().getBlock()).getValidBreak() && !event.getPlayer().isCreative()) {
                this.cancelEvent(event, (Entity)event.getPlayer(), this.colony, Action.BREAK_HUTS, event.getPos());
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS) && this.checkEventCancellation(Action.BREAK_HUTS, event.getPlayer(), (Level)world, event, event.getPos())) {
                return;
            }
            building.destroy();
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue() && event.getState().getBlock() == ModBlocks.blockHutTownHall) {
                IColonyManager.getInstance().deleteColonyByWorld(building.getColony().getID(), false, world);
            }
        } else if (event.getState().getBlock() instanceof BlockDecorationController) {
            if (this.checkEventCancellation(Action.BREAK_HUTS, event.getPlayer(), (Level)world, event, event.getPos())) {
                return;
            }
            this.colony.getBuildingManager().removeLeisureSite(event.getPos());
        } else {
            this.checkEventCancellation(Action.BREAK_BLOCKS, event.getPlayer(), event.getPlayer().getCommandSenderWorld(), event, event.getPos());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (((ServerConfiguration)MineColonies.getConfig().getServer()).turnOffExplosionsInColonies.get() == Explosions.DAMAGE_EVERYTHING) {
            return;
        }
        Level eventWorld = event.getLevel();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> (!(entity instanceof Enemy) || entity instanceof Llama) && this.colony.isCoordInColony(entity.getCommandSenderWorld(), entity.blockPosition());
        switch ((Explosions)((Object)((ServerConfiguration)MineColonies.getConfig().getServer()).turnOffExplosionsInColonies.get())) {
            case DAMAGE_NOTHING: {
                getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.getCommandSenderWorld(), entity.blockPosition());
            }
            case DAMAGE_PLAYERS: {
                List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).filter(entity -> !(entity instanceof ServerPlayer)).collect(Collectors.toList());
                event.getAffectedEntities().removeAll(entitiesToRemove);
            }
            case DAMAGE_ENTITIES: {
                List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
                event.getAffectedBlocks().removeAll(blocksToRemove);
                break;
            }
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue() && ((ServerConfiguration)MineColonies.getConfig().getServer()).turnOffExplosionsInColonies.get() == Explosions.DAMAGE_NOTHING && this.colony.isCoordInColony(event.getLevel(), BlockPos.containing((Position)event.getExplosion().center()))) {
            this.cancelEvent(event, null, this.colony, Action.EXPLODE, BlockPos.containing((Position)event.getExplosion().center()));
        }
    }

    public <T extends PlayerInteractEvent> void onPlayerInteract(T event) {
        if (this.colony.isCoordInColony(event.getLevel(), event.getPos())) {
            BlockState state = event.getLevel().getBlockState(event.getPos());
            Block block = state.getBlock();
            if (event instanceof PlayerInteractEvent.RightClickBlock && block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getEntity(), Action.ACCESS_HUTS)) {
                this.cancelEvent(event, (Entity)event.getEntity(), this.colony, Action.ACCESS_HUTS, event.getPos());
                return;
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(block, event.getPos()) && perms.hasPermission(event.getEntity(), Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if ((state.is(BlockTags.DOORS) || state.is(BlockTags.FENCE_GATES)) && perms.hasPermission(event.getEntity(), Action.ACCESS_TOGGLEABLES)) {
                return;
            }
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue()) {
                if (!perms.hasPermission(event.getEntity(), Action.RIGHTCLICK_BLOCK) && !(block instanceof AirBlock)) {
                    this.checkEventCancellation(Action.RIGHTCLICK_BLOCK, event.getEntity(), event.getLevel(), event, event.getPos());
                    return;
                }
                if (PlacementHandlers.ContainerPlacementHandler.CONTAINERS.contains(block) && !perms.hasPermission(event.getEntity(), Action.OPEN_CONTAINER)) {
                    this.cancelEvent(event, (Entity)event.getEntity(), this.colony, Action.OPEN_CONTAINER, event.getPos());
                    return;
                }
                if (event.getLevel().getBlockEntity(event.getPos()) != null && !perms.hasPermission(event.getEntity(), Action.RIGHTCLICK_ENTITY)) {
                    this.checkEventCancellation(Action.RIGHTCLICK_ENTITY, event.getEntity(), event.getLevel(), event, event.getPos());
                    return;
                }
                ItemStack stack = event.getItemStack();
                if (ItemStackUtils.isEmpty(stack) || stack.getFoodProperties((LivingEntity)event.getEntity()) != null) {
                    return;
                }
                if (stack.getItem() instanceof PotionItem) {
                    this.checkEventCancellation(Action.THROW_POTION, event.getEntity(), event.getLevel(), event, event.getPos());
                    return;
                }
                if (stack.getItem() instanceof ItemScanTool && !perms.hasPermission(event.getEntity(), Action.USE_SCAN_TOOL)) {
                    this.cancelEvent(event, (Entity)event.getEntity(), this.colony, Action.USE_SCAN_TOOL, event.getPos());
                }
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        this.onPlayerInteract(event);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        this.onPlayerInteract(event);
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        this.onPlayerInteract(event);
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && (this.colony.getFreeBlocks().contains(block) || block.defaultBlockState().is(ModTags.colonyProtectionException)) || this.colony.getFreePositions().contains(pos);
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntity(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        if (event.getEntity().getType().is(ModTags.freeToInteractWith)) {
            return;
        }
        this.checkEventCancellation(Action.RIGHTCLICK_ENTITY, event.getEntity(), event.getLevel(), event, event.getPos());
    }

    private <T extends Event> boolean checkEventCancellation(Action action, @NotNull Player playerIn, @NotNull Level world, @NotNull T event, @Nullable BlockPos pos) {
        return this.checkEventCancellation(action, playerIn, world, event, pos, ev -> ((ICancellableEvent)ev).setCanceled(true));
    }

    private <T extends Event> boolean checkEventCancellation(Action action, @NotNull Player playerIn, @NotNull Level world, @NotNull T event, @Nullable BlockPos pos, Consumer<T> eventCancellationConsumer) {
        @NotNull Player player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        BlockPos positionToCheck = pos;
        if (null == positionToCheck) {
            positionToCheck = player.blockPosition();
        }
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.getCommandSenderWorld(), positionToCheck) && !this.colony.getPermissions().hasPermission(player, action)) {
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue() && !world.isClientSide && this.colony.isValidAttackingPlayer(playerIn)) {
                return false;
            }
            this.cancelEvent(event, (Entity)player, this.colony, action, positionToCheck, eventCancellationConsumer);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntity(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancellation(Action.RIGHTCLICK_ENTITY, event.getEntity(), event.getLevel(), event, event.getPos());
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        if (this.checkEventCancellation(Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().getCommandSenderWorld(), event, event.getPlayer().blockPosition())) {
            event.getPlayer().getInventory().add(event.getEntity().getItem());
        }
    }

    @SubscribeEvent
    public void on(ItemEntityPickupEvent.Pre event) {
        if (event.getPlayer().equals((Object)event.getItemEntity().getOwner())) {
            return;
        }
        this.checkEventCancellation(Action.PICKUP_ITEM, event.getPlayer(), event.getPlayer().getCommandSenderWorld(), event, event.getPlayer().blockPosition(), ev -> ev.setCanPickup(TriState.FALSE));
    }

    @SubscribeEvent
    public void on(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.FLUID_PICKUP) {
            @Nullable BlockPos targetBlockPos = BlockPos.containing((Position)event.getEventPosition());
            if (event.getContext().sourceEntity() instanceof Player) {
                this.checkEventCancellation(Action.FILL_BUCKET, (Player)event.getContext().sourceEntity(), event.getContext().sourceEntity().getCommandSenderWorld(), event, targetBlockPos);
            }
        }
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancellation(Action.SHOOT_ARROW, event.getEntity(), event.getEntity().getCommandSenderWorld(), event, event.getEntity().blockPosition());
    }

    @SubscribeEvent
    public void on(LivingDamageEvent.Pre event) {
        if (event.getEntity() instanceof ServerPlayer && event.getSource().getEntity() instanceof EntityCitizen && ((EntityCitizen)event.getSource().getEntity()).getCitizenColonyHandler().getColonyId() == this.colony.getID() && this.colony.getRaiderManager().isRaided() && !this.colony.getPermissions().hasPermission((Player)event.getEntity(), Action.GUARDS_ATTACK)) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof Monster) {
            return;
        }
        @NotNull Player player = EntityUtils.getPlayerOfFakePlayer(event.getEntity(), event.getEntity().getCommandSenderWorld());
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.getCommandSenderWorld(), player.blockPosition())) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)event.getTarget();
                if (citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && perms.hasPermission(event.getEntity(), Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getEntity(), Action.ATTACK_CITIZEN)) {
                    return;
                }
                this.cancelEvent(event, (Entity)event.getEntity(), this.colony, Action.ATTACK_CITIZEN, event.getTarget().blockPosition());
                return;
            }
            if (!(event.getTarget() instanceof Enemy) && !perms.hasPermission(event.getEntity(), Action.ATTACK_ENTITY)) {
                this.cancelEvent(event, (Entity)event.getEntity(), this.colony, Action.ATTACK_ENTITY, event.getTarget().blockPosition());
            }
        }
    }
}

