/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.CitizenConstants;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.EntityAIKnight;
import com.minecolonies.core.util.AttributeModifierUtils;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class JobKnight
extends AbstractJobGuard<JobKnight> {
    public static final String DESC = "com.minecolonies.coremod.job.knight";

    public JobKnight(ICitizenData entity) {
        super(entity);
    }

    public EntityAIKnight generateGuardAI() {
        return new EntityAIKnight(this);
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getCitizen().getEntity().get();
            AttributeModifier healthModLevel = new AttributeModifier(CitizenConstants.GUARD_HEALTH_MOD_LEVEL_NAME, (double)(this.getCitizen().getCitizenSkillHandler().getLevel(Skill.Stamina) + 15), AttributeModifier.Operation.ADD_VALUE);
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, healthModLevel);
        }
    }

    @Override
    public ResourceLocation getModel() {
        return ModModelTypes.KNIGHT_GUARD_ID;
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.is(DamageTypeTags.IS_EXPLOSION) && this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0 && InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.SHIELD) != -1) {
            if (!this.getCitizen().getEntity().isPresent()) {
                return true;
            }
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            CitizenItemUtils.setHeldItem(worker, InteractionHand.OFF_HAND, InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.SHIELD));
            worker.startUsingItem(InteractionHand.OFF_HAND);
            ItemStack shieldStack = worker.getInventoryCitizen().getHeldItem(InteractionHand.OFF_HAND);
            shieldStack.set(DataComponents.BANNER_PATTERNS, (Object)this.getColony().getColonyFlag());
            worker.decreaseSaturationForContinuousAction();
            return true;
        }
        return super.ignoresDamage(damageSource);
    }
}

