/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.MinimumStack;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class MinimumStockModule
extends AbstractBuildingModule
implements IMinimumStockModule,
IPersistentModule,
ITickingModule,
IAltersRequiredItems {
    private static final int STOCK_PER_LEVEL = 5;
    private static final String TAG_MINIMUM_STOCK = "minstock";
    protected final Map<ItemStorage, Integer> minimumStock = new HashMap<ItemStorage, Integer>();

    private int minimumStockSize() {
        double increase = 1.0 + this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
        return (int)((double)(this.building.getBuildingLevel() * 5) * increase);
    }

    @Override
    public void addMinimumStock(ItemStack itemStack, int quantity) {
        if (this.minimumStock.containsKey(new ItemStorage(itemStack)) || this.minimumStock.size() < this.minimumStockSize()) {
            this.minimumStock.put(new ItemStorage(itemStack), quantity);
            this.markDirty();
        }
    }

    private IToken<?> getMatchingRequest(ItemStack stack, Collection<IToken<?>> list) {
        for (IToken<?> token : list) {
            IRequest<?> iRequest = this.building.getColony().getRequestManager().getRequestForToken(token);
            if (iRequest == null || !(iRequest.getRequest() instanceof Stack) || !ItemStackUtils.compareItemStacksIgnoreStackSize(((Stack)iRequest.getRequest()).getStack(), stack).booleanValue()) continue;
            return token;
        }
        return null;
    }

    @Override
    public void removeMinimumStock(ItemStack itemStack) {
        this.minimumStock.remove(new ItemStorage(itemStack));
        Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
        IToken<?> token = this.getMatchingRequest(itemStack, list);
        if (token != null) {
            this.building.getColony().getRequestManager().updateRequestState(token, RequestState.CANCELLED);
        }
        this.markDirty();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), this.building.getPosition())) {
            Collection list = this.building.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(MinimumStack.class), new ArrayList());
            for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
                ItemStack itemStack = entry.getKey().getItemStack().copy();
                if (itemStack.isEmpty()) continue;
                int target = entry.getValue() * itemStack.getMaxStackSize();
                int count = InventoryUtils.hasBuildingEnoughElseCount(this.building, new ItemStorage(itemStack, true), target);
                int delta = target - count;
                IToken<?> request = this.getMatchingRequest(itemStack, list);
                if (delta > (this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MIN_ORDER) > 0.0 ? target / 4 : 0)) {
                    if (request != null) continue;
                    int qty = Math.min(itemStack.getMaxStackSize(), delta);
                    MinimumStack stack = new MinimumStack(itemStack, false, true, ItemStackUtils.EMPTY, qty, 1);
                    stack.setCanBeResolvedByBuilding(false);
                    this.building.createRequest(stack, true);
                    continue;
                }
                if (request == null || delta > 0) continue;
                this.building.getColony().getRequestManager().updateRequestState(request, RequestState.CANCELLED);
            }
        }
    }

    @Override
    public boolean isStocked(ItemStack stack) {
        return this.minimumStock.containsKey(new ItemStorage(stack));
    }

    @Override
    public void alterItemsToBeKept(TriConsumer<Predicate<ItemStack>, Integer, Boolean> consumer) {
        if (!this.minimumStock.isEmpty()) {
            for (ItemStorage item : this.minimumStock.keySet()) {
                consumer.accept(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, item.getItemStack(), false, true), (Object)(this.minimumStock.get(item) * item.getItemStack().getMaxStackSize()), (Object)false);
            }
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.minimumStock.clear();
        ListTag minimumStockTagList = compound.getList(TAG_MINIMUM_STOCK, 10);
        for (int i = 0; i < minimumStockTagList.size(); ++i) {
            CompoundTag compoundNBT = minimumStockTagList.getCompound(i);
            this.minimumStock.put(new ItemStorage(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundNBT.getCompound("stack"))), compoundNBT.getInt("quantity"));
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        @NotNull ListTag minimumStockTagList = new ListTag();
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.put("stack", entry.getKey().getItemStack().saveOptional(provider));
            compoundNBT.putInt("quantity", entry.getValue().intValue());
            minimumStockTagList.add((Object)compoundNBT);
        }
        compound.put(TAG_MINIMUM_STOCK, (Tag)minimumStockTagList);
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.minimumStock.size());
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            Utils.serializeCodecMess(buf, entry.getKey().getItemStack());
            buf.writeInt(entry.getValue().intValue());
        }
        buf.writeBoolean(this.minimumStock.size() >= this.minimumStockSize());
    }
}

