/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.ITickingStateAI;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.utils.BuilderBucket;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingStructureBuilder
extends AbstractBuilding {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final int COUNT_TO_STORE_POS = 50;
    private BlockPos progressPos;
    private BuildingProgressStage progressStage;
    private int progressCounter = 0;
    private Map<Integer, List<BlockPos>> fluidsToRemove = new LinkedHashMap<Integer, List<BlockPos>>();

    public AbstractBuildingStructureBuilder(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (inventory) {
            int hashCode = stack.getComponentsPatch().hashCode();
            String key = stack.getDescriptionId() + "-" + hashCode;
            if (this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key)) {
                int qtyToKeep = this.getRequiredResources().getResourceMap().get(key);
                if (localAlreadyKept.contains(new ItemStorage(stack))) {
                    for (ItemStorage storage : localAlreadyKept) {
                        if (!storage.equals(new ItemStorage(stack))) continue;
                        if (storage.getAmount() >= qtyToKeep) {
                            return stack.getCount();
                        }
                        int kept = storage.getAmount();
                        if (qtyToKeep >= kept + stack.getCount()) {
                            storage.setAmount(kept + stack.getCount());
                            return 0;
                        }
                        storage.setAmount(qtyToKeep);
                        return qtyToKeep - kept - stack.getCount();
                    }
                } else {
                    if (qtyToKeep >= stack.getCount()) {
                        localAlreadyKept.add(new ItemStorage(stack));
                        return 0;
                    }
                    localAlreadyKept.add(new ItemStorage(stack, qtyToKeep, false));
                    return stack.getCount() - qtyToKeep;
                }
            }
            if (this.checkIfShouldKeepEquipment((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), stack, localAlreadyKept) || this.checkIfShouldKeepEquipment((EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), stack, localAlreadyKept) || this.checkIfShouldKeepEquipment((EquipmentTypeEntry)ModEquipmentTypes.axe.get(), stack, localAlreadyKept) || this.checkIfShouldKeepEquipment((EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), stack, localAlreadyKept)) {
                localAlreadyKept.add(new ItemStorage(stack, 1, true));
                return 0;
            }
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }

    private boolean checkIfShouldKeepEquipment(EquipmentTypeEntry type, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        if (ItemStackUtils.hasEquipmentLevel(stack, type, 0, this.getMaxEquipmentLevel())) {
            for (ItemStorage storage : localAlreadyKept) {
                if (type.getMiningLevel(stack) > type.getMiningLevel(storage.getItemStack())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BuildingBuilderResource stack : this.getModule(BuildingModules.BUILDING_RESOURCES).getNeededResources().values()) {
            toKeep.put(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack.getItemStack(), itemstack), (Tuple<Integer, Boolean>)new Tuple((Object)stack.getAmount(), (Object)true));
        }
        return toKeep;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, Level world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (ItemStackUtils.isEmpty(itemStack)) {
            this.markDirty();
        }
        return itemStack;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains("newProgressPos")) {
            this.progressPos = BlockPosUtil.read(compound, "newProgressPos");
            this.progressStage = BuildingProgressStage.values()[compound.getInt("newProgressStage")];
        }
        if (compound.contains("fluidsToRemove")) {
            this.fluidsToRemove.clear();
            ListTag fluidsToRemove = (ListTag)compound.get("fluidsToRemove");
            fluidsToRemove.forEach(fluidsRemove -> {
                int y = ((CompoundTag)fluidsRemove).getInt("yLevel");
                ListTag positions = (ListTag)((CompoundTag)fluidsRemove).get("positions");
                ArrayList<BlockPos> fluids = new ArrayList<BlockPos>();
                for (int i = 0; i < positions.size(); ++i) {
                    fluids.add(BlockPosUtil.readFromListNBT(positions, i));
                }
                this.fluidsToRemove.put(y, fluids);
            });
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.progressPos != null) {
            BlockPosUtil.write(compound, "newProgressPos", this.progressPos);
            compound.putInt("newProgressStage", this.progressStage.ordinal());
        }
        ListTag fluidsToRemove = new ListTag();
        this.fluidsToRemove.forEach((y, fluids) -> {
            CompoundTag fluidsRemove = new CompoundTag();
            ListTag positions = new ListTag();
            fluids.forEach(fluid -> BlockPosUtil.writeToListNBT(positions, fluid));
            fluidsRemove.put("positions", (Tag)positions);
            fluidsRemove.putInt("yLevel", y.intValue());
            fluidsToRemove.add((Object)fluidsRemove);
        });
        compound.put("fluidsToRemove", (Tag)fluidsToRemove);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf, boolean fullSync) {
        super.serializeToView(buf, fullSync);
        WorkerBuildingModule module = (WorkerBuildingModule)this.getFirstModuleOccurance(WorkerBuildingModule.class);
        buf.writeUtf(module.getFirstCitizen() != null ? module.getFirstCitizen().getName() : "");
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return this.getModule(BuildingModules.BUILDING_RESOURCES).getNeededResources();
    }

    @Nullable
    public BuilderBucket getRequiredResources() {
        return this.getModule(BuildingModules.BUILDING_RESOURCES).getRequiredResources();
    }

    public boolean hasResourceInBucket(ItemStack stack) {
        int hashCode = stack.getComponentsPatch().hashCode();
        String key = stack.getDescriptionId() + "-" + hashCode;
        return this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res != null) {
            ItemStack copy = res.copy();
            copy.setCount(1);
            this.getModule(BuildingModules.BUILDING_RESOURCES).addNeededResource(copy, amount);
            this.markDirty();
        }
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        this.getModule(BuildingModules.BUILDING_RESOURCES).reduceNeededResource(res, amount);
        this.markDirty();
    }

    public void resetNeededResources() {
        ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).resetNeededResources();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).requiresResourceForBuilding(stack);
    }

    public void setProgressPos(BlockPos blockPos, BuildingProgressStage stage) {
        this.progressPos = blockPos;
        if (this.progressCounter > 50 || blockPos == null || stage != this.progressStage) {
            this.markDirty();
            this.progressCounter = 0;
        } else {
            ++this.progressCounter;
        }
        this.progressStage = stage;
    }

    @Nullable
    public com.minecolonies.api.util.Tuple<BlockPos, BuildingProgressStage> getProgress() {
        if (this.progressPos == null) {
            return null;
        }
        return new com.minecolonies.api.util.Tuple<BlockPos, BuildingProgressStage>(this.progressPos, this.progressStage);
    }

    public int getResourceBatchMultiplier() {
        return 1;
    }

    public Map<Integer, List<BlockPos>> getFluidsToRemove() {
        return this.fluidsToRemove;
    }

    public void checkOrRequestBucket(@Nullable BuilderBucket requiredResources, ICitizenData worker) {
        ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).checkOrRequestBucket(requiredResources, worker);
    }

    public void nextStage() {
        ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).nextStage();
    }

    public void setTotalStages(int total) {
        ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).setTotalStages(total);
    }

    @Nullable
    public BuilderBucket getNextBucket() {
        return ((BuildingResourcesModule)this.getFirstModuleOccurance(BuildingResourcesModule.class)).getNextBucket();
    }

    public void onWorkOrderCancellation(IWorkOrder workOrder) {
        for (ICitizenData citizen : this.getAllAssignedCitizen()) {
            IJob<?> iJob = citizen.getJob();
            if (!(iJob instanceof AbstractJobStructure)) continue;
            AbstractJobStructure abstractJobStructure = (AbstractJobStructure)iJob;
            abstractJobStructure.setWorkOrder(null);
            this.cancelAllRequestsOfCitizenOrBuilding(citizen);
            ITickingStateAI iTickingStateAI = abstractJobStructure.getWorkerAI();
            if (!(iTickingStateAI instanceof AbstractEntityAIStructureWithWorkOrder)) continue;
            AbstractEntityAIStructureWithWorkOrder abstractEntityAIStructure = (AbstractEntityAIStructureWithWorkOrder)iTickingStateAI;
            abstractEntityAIStructure.resetCurrentStructure();
        }
        this.resetNeededResources();
        this.setProgressPos(null, null);
        this.cancelAllRequestsOfCitizenOrBuilding(null);
    }
}

