/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.entity.other.NewBobberEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderFishHook
extends EntityRenderer<NewBobberEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE);

    public RenderFishHook(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull NewBobberEntity entity, float p_114706_, float p_114707_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int partialTicks) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof AbstractEntityCitizen) {
            AbstractEntityCitizen citizen = (AbstractEntityCitizen)entity2;
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            PoseStack.Pose posestack$pose = poseStack.last();
            Matrix4f matrix4f = posestack$pose.pose();
            Matrix3f matrix3f = posestack$pose.normal();
            VertexConsumer vertexconsumer = buffer.getBuffer(RENDER_TYPE);
            RenderFishHook.vertex(vertexconsumer, matrix4f, posestack$pose, partialTicks, 0.0f, 0, 0, 1);
            RenderFishHook.vertex(vertexconsumer, matrix4f, posestack$pose, partialTicks, 1.0f, 0, 1, 1);
            RenderFishHook.vertex(vertexconsumer, matrix4f, posestack$pose, partialTicks, 1.0f, 1, 1, 0);
            RenderFishHook.vertex(vertexconsumer, matrix4f, posestack$pose, partialTicks, 0.0f, 1, 0, 0);
            poseStack.popPose();
            int i = citizen.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = citizen.getMainHandItem();
            if (!itemstack.is(Items.FISHING_ROD)) {
                i = -i;
            }
            float f = citizen.getAttackAnim(p_114707_);
            float f2 = Mth.lerp((float)p_114707_, (float)citizen.yBodyRotO, (float)citizen.yBodyRot) * ((float)Math.PI / 180);
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)i * 0.35;
            double d4 = Mth.lerp((double)p_114707_, (double)citizen.xo, (double)citizen.getX()) - d1 * d2 - d0 * 0.8;
            double d5 = citizen.yo + (double)citizen.getEyeHeight() + (citizen.getY() - citizen.yo) * (double)p_114707_ - 0.45;
            double d6 = Mth.lerp((double)p_114707_, (double)citizen.zo, (double)citizen.getZ()) - d0 * d2 + d1 * 0.8;
            float f3 = citizen.isCrouching() ? -0.1875f : 0.0f;
            double d9 = Mth.lerp((double)p_114707_, (double)entity.xo, (double)entity.getX());
            double d10 = Mth.lerp((double)p_114707_, (double)entity.yo, (double)entity.getY()) + 0.25;
            double d8 = Mth.lerp((double)p_114707_, (double)entity.zo, (double)entity.getZ());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            VertexConsumer vertexconsumer1 = buffer.getBuffer(RenderType.lineStrip());
            PoseStack.Pose posestack$pose1 = poseStack.last();
            int j = 16;
            for (int k = 0; k <= 16; ++k) {
                RenderFishHook.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, RenderFishHook.fraction(k, 16), RenderFishHook.fraction(k + 1, 16));
            }
            poseStack.popPose();
            super.render((Entity)entity, p_114706_, p_114707_, poseStack, buffer, partialTicks);
        }
    }

    private static float fraction(int first, int second) {
        return (float)first / (float)second;
    }

    private static void vertex(VertexConsumer consumer, Matrix4f p_114713_, PoseStack.Pose p_114714_, int p_114715_, float p_114716_, int p_114717_, int p_114718_, int p_114719_) {
        consumer.addVertex(p_114713_, p_114716_ - 0.5f, (float)p_114717_ - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)p_114718_, (float)p_114719_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114715_).setNormal(p_114714_, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer p_174122_, PoseStack.Pose p_174123_, float p_174124_, float p_174125_) {
        float f = p_174119_ * p_174124_;
        float f1 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float f2 = p_174121_ * p_174124_;
        float f3 = p_174119_ * p_174125_ - f;
        float f4 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - f1;
        float f5 = p_174121_ * p_174125_ - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        p_174122_.addVertex(p_174123_, f, f1, f2).setColor(-16777216).setNormal(p_174123_, f3 /= f6, f4 /= f6, f5 /= f6);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull NewBobberEntity entity) {
        return RenderFishHook.getTexture();
    }

    @NotNull
    private static ResourceLocation getTexture() {
        return TEXTURE;
    }
}

