/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.map;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.minecolonies.core.network.messages.client.colony.ColonyListMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum ColonySize {
    SMALL("minecolonies:gui/map/colonysmall.xml", 25),
    MEDIUM("minecolonies:gui/map/colonymedium.xml", 75),
    LARGE("minecolonies:gui/map/colonylarge.xml", 5000);

    private final String imagePath;
    private final int maxCitizens;

    private ColonySize(String imagePath, int maxCitizens) {
        this.imagePath = imagePath;
        this.maxCitizens = maxCitizens;
    }

    public static View createViewForInfo(ColonyListMessage.ColonyInfo colony) {
        View colonyPane = new View();
        ColonySize size = ColonySize.getSizeByCount(colony.getCitizencount());
        Loader.createFromXMLFile((ResourceLocation)ResourceLocation.parse((String)size.imagePath), (View)colonyPane);
        Pane background = colonyPane.findPaneByID("background");
        colonyPane.setSize(background.getWidth(), background.getHeight());
        Text colonyName = (Text)colonyPane.findPaneOfTypeByID("textcontent", Text.class);
        colonyName.setText(Component.literal((String)colony.getName()));
        return colonyPane;
    }

    public static ColonySize getSizeByCount(int count) {
        for (ColonySize size : ColonySize.values()) {
            if (count >= size.maxCitizens) continue;
            return size;
        }
        return SMALL;
    }
}

