/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.items.ItemCrop;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecoloniesCropBlock
extends AbstractBlockMinecolonies<MinecoloniesCropBlock> {
    public static String BELL_PEPPER = "bell_pepper";
    public static String CABBAGE = "cabbage";
    public static String CHICKPEA = "chickpea";
    public static String DURUM = "durum";
    public static String EGGPLANT = "eggplant";
    public static String GARLIC = "garlic";
    public static String ONION = "onion";
    public static String SOYBEAN = "soybean";
    public static String TOMATO = "tomato";
    public static String RICE = "rice";
    public static String BUTTERNUT_SQUASH = "butternut_squash";
    public static String CORN = "corn";
    public static String MINT = "mint";
    public static String NETHER_PEPPER = "nether_pepper";
    public static String PEAS = "peas";
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)6);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};
    private final Block preferredFarmland;
    private final List<Block> droppedFrom;
    private final ResourceLocation blockId;
    private final TagKey<Biome> preferredBiome;

    public MinecoloniesCropBlock(String blockName, Block preferredFarmland, List<Block> droppedFrom, @Nullable TagKey<Biome> preferredBiome) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.blockId = new ResourceLocation("minecolonies", blockName);
        this.preferredFarmland = preferredFarmland;
        this.droppedFrom = droppedFrom;
        this.preferredBiome = preferredBiome;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    public final boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= this.getMaxAge();
    }

    protected int getMaxAge() {
        return 6;
    }

    public void attemptGrow(BlockState state, ServerLevel level, BlockPos pos) {
        if (level.isAreaLoaded(pos, 1) && level.getRawBrightness(pos, 0) >= 9) {
            Colony colony;
            IColony iColony;
            BlockPos offset = pos.relative(Direction.Plane.HORIZONTAL.getRandomDirection(level.random));
            if (WorldUtil.isBlockLoaded((LevelAccessor)level, offset) && level.getBlockState(offset.below()).getBlock() == level.getBlockState(pos.below()).getBlock() && level.getBlockState(offset).isAir() && (iColony = IColonyManager.getInstance().getColonyByPosFromWorld((Level)level, pos)) instanceof Colony && (colony = (Colony)iColony).getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GREEN_REVOLUTION) > 0.0) {
                level.setBlock(offset, this.defaultBlockState(), 3);
            } else {
                int i = (Integer)state.getValue((Property)AGE);
                if (i < this.getMaxAge()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                }
            }
        }
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, @NotNull BlockPos pos) {
        return !(level.getRawBrightness(pos, 0) < 8 && !level.canSeeSky(pos) || !super.canSurvive(state, level, pos) || level.getBlockState(pos.below()).getBlock() != this.preferredFarmland || this.preferredBiome != null && !level.getBiome(pos).is(this.preferredBiome));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> creator) {
        creator.add(new Property[]{AGE});
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction dir, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, dir, newState, level, pos, neighborPos);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(state, pathComputationType);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.blockId;
    }

    @Override
    public void registerBlockItem(Registry<Item> registry, Item.Properties properties) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)((Object)new ItemCrop(this, properties, this.preferredBiome)));
    }

    public Block getPreferredFarmland() {
        return this.preferredFarmland;
    }

    public List<Block> getDroppedFrom() {
        return this.droppedFrom;
    }

    @Nullable
    public TagKey<Biome> getPreferredBiome() {
        return this.preferredBiome;
    }
}

