/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.loot.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchUnlocked
implements LootItemCondition {
    public static final MapCodec<ResearchUnlocked> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(r -> r.effectId), (App)Codec.DOUBLE.optionalFieldOf("minStrength", (Object)Double.MIN_VALUE).forGetter(r -> r.minStrength), (App)Codec.DOUBLE.optionalFieldOf("maxStrength", (Object)Double.MAX_VALUE).forGetter(r -> r.maxStrength)).apply((Applicative)builder, ResearchUnlocked::new));
    private final ResourceLocation effectId;
    private final double minStrength;
    private final double maxStrength;

    private ResearchUnlocked(@NotNull ResourceLocation effectId, double minStrength, double maxStrength) {
        this.effectId = effectId;
        this.minStrength = minStrength;
        this.maxStrength = maxStrength;
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId) {
        return ResearchUnlocked.effect(effectId, Double.MIN_VALUE);
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId, double strength) {
        return ResearchUnlocked.effect(effectId, strength, Double.MAX_VALUE);
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId, double minStrength, double maxStrength) {
        return () -> new ResearchUnlocked(effectId, minStrength, maxStrength);
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootConditions.researchUnlocked.get();
    }

    public boolean test(@NotNull LootContext lootContext) {
        return this.test(lootContext, (Entity)lootContext.getParamOrNull(LootContextParams.ATTACKING_ENTITY)).or(() -> this.test(lootContext, (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY))).or(() -> this.test(lootContext, (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN))).orElse(false);
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable Entity entity) {
        return Optional.ofNullable(entity).map(e -> {
            AbstractEntityCitizen citizen;
            return e instanceof AbstractEntityCitizen ? (citizen = (AbstractEntityCitizen)e) : null;
        }).flatMap(c -> this.test(lootContext, c.getCitizenColonyHandler().getColonyOrRegister()));
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable Vec3 origin) {
        return Optional.ofNullable(origin).map(BlockPos::containing).flatMap(pos -> this.test(lootContext, IColonyManager.getInstance().getIColony((Level)lootContext.getLevel(), (BlockPos)pos)));
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable IColony colony) {
        return Optional.ofNullable(colony).map(c -> c.getResearchManager().getResearchEffects().getEffectStrength(this.effectId)).map(s -> s >= this.minStrength && s < this.maxStrength);
    }
}

